/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.recipe.registry.impl;

import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.recipe.registry.impl.CraftingRecipeRegistry;
import java.util.List;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.jetbrains.annotations.NotNull;

public final class ShapelessRecipeRegistry
extends CraftingRecipeRegistry {
    private List<RecipeChoice> choiceList;

    public ShapelessRecipeRegistry(@NotNull String group, @NotNull NamespacedKey namespacedKey, @NotNull ItemStack result) {
        super(group, namespacedKey, result);
    }

    public List<RecipeChoice> choiceList() {
        return this.choiceList;
    }

    public ShapelessRecipeRegistry setChoiceList(List<RecipeChoice> choiceList) {
        this.choiceList = choiceList;
        return this;
    }

    @Override
    public ShapelessRecipeRegistry setCraftingBookCategory(CraftingBookCategory craftingBookCategory) {
        return (ShapelessRecipeRegistry)super.setCraftingBookCategory(craftingBookCategory);
    }

    @Override
    public void register() {
        Objects.requireNonNull(this.namespacedKey(), "Recipe key cannot be null");
        Objects.requireNonNull(this.result(), "Recipe key cannot be null");
        Objects.requireNonNull(this.choiceList, "Recipe ingredients cannot be null");
        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(this.namespacedKey(), this.result());
        for (RecipeChoice choice : this.choiceList) {
            shapelessRecipe.addIngredient(choice);
        }
        if (this.craftingBookCategory != null) {
            shapelessRecipe.setCategory(this.craftingBookCategory);
        }
        shapelessRecipe.setGroup(this.group());
        RecipeManager.INSTANCE.regRecipe(this.group(), (Recipe)shapelessRecipe, RecipeType.SHAPELESS);
    }
}

