/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.recipe.registry.impl;

import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.MinecraftVersion;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeType;
import com.github.yufiriamazenta.craftorithm.recipe.registry.RecipeRegistry;
import java.util.Objects;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmithingRecipeRegistry
extends RecipeRegistry {
    private RecipeChoice template;
    private SmithingType smithingType = SmithingType.TRANSFORM;
    private RecipeChoice base;
    private RecipeChoice addition;
    protected boolean copyNbt = false;
    protected boolean copyEnchantments = true;

    public SmithingRecipeRegistry(@NotNull String recipeGroup, @NotNull NamespacedKey namespacedKey, @Nullable ItemStack result) {
        super(recipeGroup, namespacedKey, result);
    }

    public RecipeChoice template() {
        return this.template;
    }

    public SmithingRecipeRegistry setTemplate(RecipeChoice template) {
        this.template = template;
        return this;
    }

    public RecipeChoice base() {
        return this.base;
    }

    public SmithingRecipeRegistry setBase(RecipeChoice base) {
        this.base = base;
        return this;
    }

    public RecipeChoice addition() {
        return this.addition;
    }

    public SmithingRecipeRegistry setAddition(RecipeChoice addition) {
        this.addition = addition;
        return this;
    }

    public boolean copyNbt() {
        if (MinecraftVersion.current().afterOrEquals(MinecraftVersion.V1_20_5)) {
            return !this.copyNbt;
        }
        return this.copyNbt;
    }

    public SmithingRecipeRegistry setCopyNbt(boolean copyNbt) {
        this.copyNbt = copyNbt;
        return this;
    }

    public boolean copyEnchantments() {
        return this.copyEnchantments;
    }

    public SmithingRecipeRegistry setCopyEnchantments(boolean copyEnchantments) {
        this.copyEnchantments = copyEnchantments;
        return this;
    }

    @Override
    public void register() {
        SmithingTrimRecipe smithingRecipe;
        Objects.requireNonNull(this.namespacedKey(), "Recipe key cannot be null");
        Objects.requireNonNull(this.base(), "Recipe base cannot be null");
        Objects.requireNonNull(this.addition(), "Recipe addition cannot be null");
        Objects.requireNonNull(this.template, "Recipe template cannot be null");
        if (Objects.requireNonNull(this.smithingType) == SmithingType.TRIM) {
            smithingRecipe = CrypticLibBukkit.isPaper() ? new SmithingTrimRecipe(this.namespacedKey(), this.template, this.base(), this.addition(), this.copyNbt()) : new SmithingTrimRecipe(this.namespacedKey(), this.template, this.base(), this.addition());
        } else {
            Objects.requireNonNull(this.result(), "Recipe result cannot be null");
            smithingRecipe = CrypticLibBukkit.isPaper() ? new SmithingTransformRecipe(this.namespacedKey(), this.result(), this.template, this.base(), this.addition(), this.copyNbt()) : new SmithingTransformRecipe(this.namespacedKey(), this.result(), this.template, this.base(), this.addition());
        }
        RecipeManager.INSTANCE.regRecipe(this.group(), (Recipe)smithingRecipe, RecipeType.SMITHING);
    }

    public SmithingType smithingType() {
        return this.smithingType;
    }

    public SmithingRecipeRegistry setSmithingType(SmithingType smithingType) {
        this.smithingType = smithingType;
        return this;
    }

    public static enum SmithingType {
        TRIM,
        TRANSFORM;

    }
}

