/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.util;

import com.github.yufiriamazenta.craftorithm.config.PluginConfigs;
import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.MinecraftVersion;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.recipe.RecipeManager;
import com.github.yufiriamazenta.craftorithm.recipe.custom.AnvilRecipe;
import java.lang.runtime.SwitchBootstraps;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class EventUtils {
    public static final Boolean hasCrafterCraftEvent = EventUtils.getHasCrafterCraftEvent();

    private static Boolean getHasCrafterCraftEvent() {
        try {
            Class.forName("org.bukkit.event.block.CrafterCraftEvent");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isCraftorithmRecipeEvent(Event event) {
        Recipe recipe = null;
        Event event2 = event;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CraftItemEvent.class, PrepareItemCraftEvent.class, PrepareSmithingEvent.class, SmithItemEvent.class, FurnaceSmeltEvent.class, BlockCookEvent.class, CampfireStartEvent.class, PrepareAnvilEvent.class}, (Object)event2, n)) {
            case 0: {
                CraftItemEvent craftItemEvent = (CraftItemEvent)event2;
                recipe = craftItemEvent.getRecipe();
                break;
            }
            case 1: {
                PrepareItemCraftEvent prepareItemCraftEvent = (PrepareItemCraftEvent)event2;
                recipe = prepareItemCraftEvent.getRecipe();
                break;
            }
            case 2: {
                PrepareSmithingEvent prepareSmithingEvent = (PrepareSmithingEvent)event2;
                recipe = prepareSmithingEvent.getInventory().getRecipe();
                break;
            }
            case 3: {
                SmithItemEvent smithItemEvent = (SmithItemEvent)event2;
                recipe = smithItemEvent.getInventory().getRecipe();
                break;
            }
            case 4: {
                FurnaceSmeltEvent furnaceSmeltEvent = (FurnaceSmeltEvent)event2;
                recipe = furnaceSmeltEvent.getRecipe();
                break;
            }
            case 5: {
                BlockCookEvent blockCookEvent = (BlockCookEvent)event2;
                recipe = blockCookEvent.getRecipe();
                break;
            }
            case 6: {
                CampfireStartEvent campfireStartEvent = (CampfireStartEvent)event2;
                recipe = campfireStartEvent.getRecipe();
                break;
            }
            case 7: {
                PrepareAnvilEvent prepareAnvilEvent = (PrepareAnvilEvent)event2;
                if (!CrypticLibBukkit.isPaper()) {
                    return false;
                }
                if (!((Boolean)PluginConfigs.ENABLE_ANVIL_RECIPE.value()).booleanValue()) {
                    return false;
                }
                ItemStack base = prepareAnvilEvent.getInventory().getItem(0);
                ItemStack addition = prepareAnvilEvent.getInventory().getItem(1);
                if (ItemHelper.isAir(base) || ItemHelper.isAir(addition)) {
                    return false;
                }
                AnvilRecipe anvilRecipe = RecipeManager.INSTANCE.matchAnvilRecipe(base, addition);
                return anvilRecipe != null;
            }
            case -1: {
                return false;
            }
            default: {
                if (MinecraftVersion.current().afterOrEquals(MinecraftVersion.V1_17_1) && event instanceof FurnaceStartSmeltEvent) {
                    FurnaceStartSmeltEvent furnaceStartSmeltEvent = (FurnaceStartSmeltEvent)event;
                    recipe = furnaceStartSmeltEvent.getRecipe();
                }
                if (!hasCrafterCraftEvent.booleanValue() || !(event instanceof CrafterCraftEvent)) break;
                CrafterCraftEvent crafterCraftEvent = (CrafterCraftEvent)event;
                recipe = crafterCraftEvent.getRecipe();
            }
        }
        if (recipe == null) {
            return false;
        }
        NamespacedKey recipeKey = RecipeManager.INSTANCE.getRecipeKey(recipe);
        return recipeKey != null && recipeKey.getNamespace().equals(RecipeManager.INSTANCE.PLUGIN_RECIPE_NAMESPACE);
    }
}

