/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.util;

import com.github.yufiriamazenta.craftorithm.config.PluginConfigs;
import com.github.yufiriamazenta.craftorithm.crypticlib.chat.BukkitTextProcessor;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.AutoTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.BukkitLifeCycleTask;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.LifeCycle;
import com.github.yufiriamazenta.craftorithm.crypticlib.lifecycle.TaskRule;
import com.github.yufiriamazenta.craftorithm.crypticlib.util.ItemHelper;
import com.github.yufiriamazenta.craftorithm.item.ItemManager;
import com.github.yufiriamazenta.craftorithm.item.impl.CraftorithmItemProvider;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

@AutoTask(rules={@TaskRule(lifeCycle=LifeCycle.ENABLE), @TaskRule(lifeCycle=LifeCycle.RELOAD)})
public class ItemUtils
implements BukkitLifeCycleTask {
    private static String cannotCraftLore;
    private static Pattern cannotCraftLorePattern;
    private static boolean cannotCraftLoreIsRegex;

    public static void reloadCannotCraftLore() {
        cannotCraftLore = BukkitTextProcessor.color((String)PluginConfigs.LORE_CANNOT_CRAFT.value());
        try {
            cannotCraftLorePattern = Pattern.compile(cannotCraftLore);
            cannotCraftLoreIsRegex = true;
        }
        catch (PatternSyntaxException e) {
            cannotCraftLoreIsRegex = false;
        }
    }

    public static boolean hasCannotCraftLore(ItemStack ... items) {
        if (cannotCraftLore == null) {
            return false;
        }
        boolean containsLore = false;
        for (ItemStack item : items) {
            List lore;
            ItemMeta meta;
            if (item == null || (meta = item.getItemMeta()) == null || (lore = item.getItemMeta().getLore()) == null) continue;
            for (String loreStr : lore) {
                if (!cannotCraftLoreIsRegex) {
                    if (!loreStr.equals(cannotCraftLore)) continue;
                    containsLore = true;
                    break;
                }
                Matcher matcher = cannotCraftLorePattern.matcher(loreStr);
                if (!matcher.find()) continue;
                containsLore = true;
                break;
            }
            if (containsLore) break;
        }
        return containsLore;
    }

    public static String matchItemNameOrCreate(ItemStack item, boolean ignoreAmount) {
        Object itemName;
        if (ItemHelper.isAir(item)) {
            return null;
        }
        if (item.hasItemMeta()) {
            itemName = ItemManager.INSTANCE.matchItemName(item, ignoreAmount);
            if (itemName == null) {
                String id = UUID.randomUUID().toString();
                itemName = "items:" + CraftorithmItemProvider.INSTANCE.regCraftorithmItem("gui_items", id, item);
            }
        } else {
            itemName = item.getType().getKey().toString();
            if (!ignoreAmount && item.getAmount() > 1) {
                itemName = (String)itemName + " " + item.getAmount();
            }
        }
        return itemName;
    }

    public static void toggleItemGlowing(ItemStack item) {
        if (item.containsEnchantment(Enchantment.MENDING)) {
            item.removeEnchantment(Enchantment.MENDING);
            ItemMeta itemMeta = item.getItemMeta();
            itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(itemMeta);
        } else {
            item.addUnsafeEnchantment(Enchantment.MENDING, 1);
            ItemMeta itemMeta = item.getItemMeta();
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(itemMeta);
        }
    }

    @Override
    public void run(Plugin plugin, LifeCycle lifeCycle) {
        ItemUtils.reloadCannotCraftLore();
    }
}

