/*
 * Decompiled with CFR 0.152.
 */
package com.github.yufiriamazenta.craftorithm.util;

import com.github.yufiriamazenta.craftorithm.Craftorithm;
import com.github.yufiriamazenta.craftorithm.config.Languages;
import com.github.yufiriamazenta.craftorithm.config.PluginConfigs;
import com.github.yufiriamazenta.craftorithm.crypticlib.CrypticLibBukkit;
import com.github.yufiriamazenta.craftorithm.crypticlib.listener.EventListener;
import com.github.yufiriamazenta.craftorithm.util.CollectionsUtils;
import com.github.yufiriamazenta.craftorithm.util.LangUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@EventListener
public class UpdateChecker
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer().isOp()) {
            UpdateChecker.pullUpdateCheckRequest((CommandSender)event.getPlayer());
        }
    }

    public static void pullUpdateCheckRequest(CommandSender sender) {
        if (!((Boolean)PluginConfigs.CHECK_UPDATE.value()).booleanValue()) {
            return;
        }
        CrypticLibBukkit.scheduler().async(() -> {
            try {
                URL url = new URL("https://api.spigotmc.org/legacy/update.php?resource=108429/");
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(15000);
                conn.setReadTimeout(60000);
                InputStream is = conn.getInputStream();
                String latestVersion = new BufferedReader(new InputStreamReader(is)).readLine();
                String pluginVersion = Craftorithm.instance().getDescription().getVersion();
                pluginVersion = pluginVersion.substring(0, pluginVersion.indexOf("-"));
                if (UpdateChecker.checkVersion(latestVersion, pluginVersion)) {
                    CrypticLibBukkit.scheduler().sync(() -> LangUtils.sendLang(sender, Languages.NEW_VERSION, CollectionsUtils.newStringHashMap("<new_version>", latestVersion)));
                }
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static boolean checkVersion(String newVersion, String version) {
        int latestVer;
        int subVer;
        if (newVersion.equals(version)) {
            return false;
        }
        String[] newVersionNum = newVersion.split("\\.");
        String[] versionNum = version.split("\\.");
        int newRootVer = Integer.parseInt(newVersionNum[0]);
        int rootVer = Integer.parseInt(versionNum[0]);
        if (rootVer < newRootVer) {
            return true;
        }
        if (rootVer > newRootVer) {
            return false;
        }
        int newSubVer = Integer.parseInt(newVersionNum[1]);
        if (newSubVer > (subVer = Integer.parseInt(versionNum[1]))) {
            return true;
        }
        if (subVer > newSubVer) {
            return false;
        }
        int newLatestVer = Integer.parseInt(newVersionNum[2]);
        return newLatestVer > (latestVer = Integer.parseInt(versionNum[2]));
    }
}

