/*
 * Decompiled with CFR 0.152.
 */
package net.elaguilamc623.complementary_structures.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.elaguilamc623.complementary_structures.registry.ModStructurePlacements;
import net.elaguilamc623.complementary_structures.structures.CustomExclusionZone;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class AdvancedStructurePlacement
extends RandomSpreadStructurePlacement {
    public static final Codec<AdvancedStructurePlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3i.m_194650_((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.f_123288_).forGetter(AdvancedStructurePlacement::getLocateOffset), (App)StructurePlacement.FrequencyReductionMethod.f_227108_.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(AdvancedStructurePlacement::getFrequencyReductionMethod), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(AdvancedStructurePlacement::getFrequency), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(AdvancedStructurePlacement::getSalt), (App)StructurePlacement.ExclusionZone.f_227077_.optionalFieldOf("exclusion_zone").forGetter(AdvancedStructurePlacement::getExclusionZone), (App)CustomExclusionZone.CODEC.optionalFieldOf("custom_exclusion_zone").forGetter(AdvancedStructurePlacement::getCustomExclusionZone), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::m_205003_), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::m_205004_), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(RandomSpreadStructurePlacement::m_205005_)).apply((Applicative)instance, AdvancedStructurePlacement::new));
    private final Optional<CustomExclusionZone> customExclusionZone;

    public AdvancedStructurePlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.ExclusionZone> exclusionZone, Optional<CustomExclusionZone> customExclusionZone, int spacing, int separation, RandomSpreadType spreadType) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, spreadType);
        this.customExclusionZone = customExclusionZone;
    }

    public Vec3i getLocateOffset() {
        return this.m_227072_();
    }

    public StructurePlacement.FrequencyReductionMethod getFrequencyReductionMethod() {
        return this.m_227073_();
    }

    public float getFrequency() {
        return this.m_227074_();
    }

    public int getSalt() {
        return this.m_227075_();
    }

    public Optional<StructurePlacement.ExclusionZone> getExclusionZone() {
        return this.m_227076_();
    }

    public Optional<CustomExclusionZone> getCustomExclusionZone() {
        return this.customExclusionZone;
    }

    private List<Holder<StructureSet>> getRelevantSets() {
        return this.customExclusionZone.map(zone -> zone.sets().m_203614_().toList()).orElse(List.of());
    }

    public boolean m_255071_(ChunkGeneratorStructureState state, int chunkX, int chunkZ) {
        boolean baseValid = super.m_255071_(state, chunkX, chunkZ);
        if (!baseValid) {
            return false;
        }
        if (this.customExclusionZone.isPresent()) {
            CustomExclusionZone zone = this.customExclusionZone.get();
            int radius = zone.radius();
            for (Holder holder : zone.sets()) {
                if (!state.m_254936_(holder, chunkX, chunkZ, radius)) continue;
                System.out.println("[AdvancedPlacement] Chunk rechazado por proximidad a " + holder.m_203543_().map(ResourceKey::m_135782_).orElse(new ResourceLocation("unknown")));
                return false;
            }
        }
        return true;
    }

    public StructurePlacementType<?> m_203443_() {
        return (StructurePlacementType)ModStructurePlacements.ADVANCED_PLACEMENT.get();
    }
}

