/*
 * Decompiled with CFR 0.152.
 */
package com.liba.utils;

import com.liba.utils.MinecraftColor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUtil {
    public static ItemStack create(ItemStack itemStack, String title) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(MinecraftColor.format(title));
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack create(ItemStack itemStack, String title, String ... lore) {
        ItemStack item = ItemUtil.create(itemStack, title);
        ItemUtil.addLore(itemStack, lore);
        return item;
    }

    public static ItemStack create(ItemStack itemStack, String title, List<String> lore) {
        ItemStack item = ItemUtil.create(itemStack, title);
        ItemUtil.addLore(itemStack, lore);
        return item;
    }

    public static ItemStack rename(ItemStack itemStack, String name) {
        return ItemUtil.create(itemStack, name);
    }

    public static ItemStack addLore(ItemStack itemStack, String ... lore) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null && lore.length > 0) {
            ArrayList lores = new ArrayList();
            Arrays.stream(lore).forEach(e -> {
                if (!Objects.equals(e, "")) {
                    lores.add(MinecraftColor.format(e));
                }
            });
            meta.setLore(lores);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    public static ItemStack addLore(ItemStack itemStack, List<String> lore) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null && !lore.isEmpty()) {
            meta.setLore(lore.stream().map(MinecraftColor::format).collect(Collectors.toList()));
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    public static String getMaterialName(String name) {
        String[] split = name.split("_");
        if (split.length > 1) {
            return IntStream.range(0, split.length).mapToObj(i -> i == 0 ? split[i].substring(0, 1).toUpperCase() + split[i].substring(1).toLowerCase() : split[i].toLowerCase()).collect(Collectors.joining(" "));
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    public static Integer getDamage(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        try {
            Class<?> damageableClass = Class.forName("org.bukkit.inventory.meta.Damageable");
            Method getDamageMethod = damageableClass.getMethod("getDamage", new Class[0]);
            return (int)((Integer)getDamageMethod.invoke((Object)meta, new Object[0]));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void damageItem(ItemStack itemStack, int amount, boolean breaklower) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return;
        }
        try {
            Class<?> damageableClass = Class.forName("org.bukkit.inventory.meta.Damageable");
            Method getDamageMethod = damageableClass.getMethod("getDamage", new Class[0]);
            Method setDamageMethod = damageableClass.getMethod("setDamage", Integer.TYPE);
            int curentdamage = (Integer)getDamageMethod.invoke((Object)meta, new Object[0]);
            if (breaklower && curentdamage + amount >= itemStack.getType().getMaxDurability()) {
                itemStack.setAmount(itemStack.getAmount() - 1);
            }
            setDamageMethod.invoke((Object)meta, curentdamage + amount);
            itemStack.setItemMeta(meta);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

