/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.events;

import com.liba.utils.player.PlayerUtils;
import com.modencore.ChunkLoader;
import com.modencore.chunk.BlockChunk;
import com.modencore.crafts.PluginCrafts;
import com.modencore.lang.Lang;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ChunkEvents
implements Listener {
    Lang lang;

    public ChunkEvents(Lang lang) {
        this.lang = lang;
    }

    @EventHandler
    public void blockPlace(BlockPlaceEvent e) {
        String string;
        ItemMeta meta;
        ItemStack itemStack = e.getItemInHand();
        if (itemStack.getItemMeta() != null && (meta = itemStack.getItemMeta()).getPersistentDataContainer().has(PluginCrafts.CHUNK_BLOCK.getCraft().getKey()) && (string = (String)meta.getPersistentDataContainer().get(PluginCrafts.CHUNK_BLOCK.getCraft().getKey(), PersistentDataType.STRING)) != null && string.equalsIgnoreCase(PluginCrafts.CHUNK_BLOCK.getCraft().getKey().getKey())) {
            if (ChunkLoader.getPlugin().getBlockChunkChunk(e.getBlockPlaced().getChunk()) != null) {
                e.setCancelled(true);
                e.getPlayer().sendMessage(this.lang.prefix("chunkblock.errorplace"));
                return;
            }
            PlayerUtils.sendMessage(e.getPlayer().getUniqueId(), this.lang.prefix("chunkblock.placemessage"));
            BlockChunk blockChunk = new BlockChunk(e.getPlayer().getUniqueId(), e.getBlockPlaced().getLocation(), UUID.randomUUID());
            ChunkLoader.getPlugin().load(blockChunk);
            ChunkLoader.getPlugin().getStorage().save(blockChunk);
        }
    }

    @EventHandler
    public void blockBreak(BlockBreakEvent e) {
        Optional<BlockChunk> ochunk;
        if (e.getBlock().getType().equals((Object)PluginCrafts.CHUNK_BLOCK.getCraft().getItem().getType()) && (ochunk = ChunkLoader.getPlugin().getLoadedChunk().stream().filter(f -> f.getLocation().equals((Object)e.getBlock().getLocation())).findFirst()).isPresent()) {
            BlockChunk blockChunk = ochunk.get();
            ChunkLoader.getPlugin().remove(blockChunk);
            e.setDropItems(false);
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation().clone().add(0.5, 0.5, 0.5), PluginCrafts.CHUNK_BLOCK.getCraft().getItem());
            PlayerUtils.sendMessage(e.getPlayer().getUniqueId(), this.lang.prefix("chunkblock.breakmessage"));
            ChunkLoader.getPlugin().getStorage().remove(blockChunk.getKey().toString());
        }
    }

    @EventHandler
    public void openBlock(PlayerInteractEvent e) {
        Optional<BlockChunk> ochunk;
        if (e.getClickedBlock() == null || e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getClickedBlock().getType().equals((Object)PluginCrafts.CHUNK_BLOCK.getCraft().getItem().getType()) && (ochunk = ChunkLoader.getPlugin().getLoadedChunk().stream().filter(f -> f.getLocation().equals((Object)e.getClickedBlock().getLocation())).findFirst()).isPresent()) {
            BlockChunk blockChunk = ochunk.get();
            blockChunk.getMenu().open(e.getPlayer());
        }
    }
}

