/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.menus;

import com.liba.menu.Menu;
import com.liba.menu.MenuSlot;
import com.liba.menu.buttons.TextButton;
import com.liba.utils.ItemUtil;
import com.liba.utils.headcreator.HeadCache;
import java.util.List;
import java.util.function.BiConsumer;
import org.bukkit.inventory.ItemStack;

public abstract class ListedMenu<T>
extends Menu {
    List<T> data;
    int datarows;
    int page;
    int pages;

    public ListedMenu(String title, int size, List<T> data, int datarows) {
        super(title, size);
        this.data = data;
        this.datarows = datarows * 9;
        this.setGlobalAction((player, inventoryClickEvent) -> inventoryClickEvent.setCancelled(true));
    }

    public ListedMenu(String string, int size, List<T> data, int datarows, Menu back) {
        super(string, size, back);
        this.data = data;
        this.datarows = datarows * 9;
        this.setGlobalAction((player, inventoryClickEvent) -> inventoryClickEvent.setCancelled(true));
    }

    public void setItems(BiConsumer<T, Integer> consumer) {
        this.getInventory().clear();
        ItemStack nextButton = ItemUtil.create(HeadCache.getItem("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYWM5YzY3YTlmMTY4NWNkMWRhNDNlODQxZmU3ZWJiMTdmNmFmNmVhMTJhN2UxZjI3MjJmNWU3ZjA4OThkYjlmMyJ9fX0="), "Next page");
        ItemStack previusPage = ItemUtil.create(HeadCache.getItem("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWExZWYzOThhMTdmMWFmNzQ3NzAxNDUxN2Y3ZjE0MWQ4ODZkZjQxYTMyYzczOGNjOGE4M2ZiNTAyOTdiZDkyMSJ9fX0="), "Previus page");
        int start = this.page * this.datarows;
        int end = Math.min(start + this.datarows, this.data.size());
        for (int i = start; i < end; ++i) {
            T element = this.data.get(i);
            int slot = i - start;
            consumer.accept(element, slot);
        }
        if ((this.page + 1) * this.datarows < this.data.size()) {
            this.addSlot(this.getInventory().getSize() - 2, new MenuSlot(new TextButton(nextButton), (p, e) -> {
                ++this.page;
                this.setItems(consumer);
                this.open(p);
            }));
        }
        if (this.page > 0) {
            this.addSlot(this.getInventory().getSize() - 8, new MenuSlot(new TextButton(previusPage), (p, e) -> {
                --this.page;
                this.setItems(consumer);
                this.open(p);
            }));
        }
    }
}

