/*
 * Decompiled with CFR 0.152.
 */
package com.liba;

import com.liba.gui.listeners.InventoryListener;
import com.liba.menu.listener.MenuListener;
import com.liba.utils.Debug;
import com.liba.utils.file.FileChecker;
import com.liba.version.VersionChecker;
import com.liba.version.VersionListener;
import com.libs.bukkit.Metrics;
import java.io.File;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Liba {
    private static Plugin plugin;
    private static Liba liba;
    FileChecker config;

    public Liba(Plugin plugin) {
        liba = this;
        Liba.setPlugin(plugin);
        this.config = new FileChecker(String.valueOf(plugin.getDataFolder()) + File.separator + "dev.yml"){

            @Override
            public void needle() {
                this.addParam("version-notifier", true, "If enabled, you will be notified when new versions are available");
                this.addParam("debug", false, "Need for testing plugin, do not use on production ");
            }
        };
        this.config.checkStorage();
        Debug.setDebug(this.config.getBool("debug"));
        Liba.getPlugin().getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), plugin);
        Liba.getPlugin().getServer().getPluginManager().registerEvents((Listener)new MenuListener(), plugin);
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static void setPlugin(Plugin plugin) {
        Liba.plugin = plugin;
    }

    public static Liba getLiba() {
        return liba;
    }

    public VersionChecker registerVersionChecker(int id, String site) {
        VersionChecker checker = new VersionChecker(id, site);
        plugin.getServer().getPluginManager().registerEvents((Listener)new VersionListener(checker), plugin);
        return checker;
    }

    public Metrics registerMetrica(int serverid) {
        return new Metrics((Plugin)((JavaPlugin)plugin), serverid);
    }

    public FileChecker getConfig() {
        return this.config;
    }

    public void onDisable() {
    }
}

