/*
 * Decompiled with CFR 0.152.
 */
package com.liba.gui;

import com.liba.gui.Gui;
import com.liba.gui.buttons.DebugButton;
import com.liba.gui.buttons.NextButton;
import com.liba.gui.buttons.PreviusButton;
import com.liba.utils.Debug;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public abstract class ListedGui
extends Gui {
    int page = 0;
    int dataPerPage;
    int pages;
    List<?> data;
    String nextbtnmsg = "Next page";
    String prewbtnmsg = "Previous page";

    public <T> ListedGui(String title, int rows, List<T> data, int dataPerPage) {
        super(title, rows);
        this.dataPerPage = dataPerPage;
        this.pages = data.size() / this.dataPerPage;
        this.data = data;
    }

    public <T> ListedGui(String title, int rows, List<T> data, int dataPerPage, Gui backgui) {
        super(title, rows, backgui);
        this.dataPerPage = dataPerPage;
        this.pages = data.size() / dataPerPage;
        this.data = data;
    }

    @Override
    public void setInventoryItems() {
        if (this.pages != this.data.size() / this.dataPerPage) {
            this.pages = this.data.size() / this.dataPerPage;
        }
        if (this.getPage() - 1 >= 0) {
            this.addSlot(this.getSlots() - 8, new PreviusButton(new ItemStack(Material.ARROW), this));
        } else {
            this.removeSlot(this.getSlots() - 8);
        }
        if (this.getPage() + 1 <= this.getPages()) {
            this.addSlot(this.getSlots() - 2, new NextButton(new ItemStack(Material.ARROW), this));
        } else {
            this.removeSlot(this.getSlots() - 2);
        }
        if (Debug.isDebug()) {
            this.addSlot(this.getSlots() - 4, new DebugButton("\u00a7aRows " + this.getRows(), "\u00a7aSlots " + this.getSlots(), "\u00a7aDataSize " + this.getData().size(), "\u00a7aPage " + this.getPage(), "\u00a7aPageCount " + this.getPages(), "\u00a7aDataBlock " + this.getDataPerPage()));
        }
    }

    public void nextPage() {
        ++this.page;
        this.setInventoryItems();
    }

    public void previusPage() {
        --this.page;
        this.setInventoryItems();
    }

    public List<?> getData() {
        return this.data;
    }

    public void setData(List<?> data) {
        this.data = data;
        this.setPages(data.size() / this.dataPerPage);
    }

    public int getDataPerPage() {
        return this.dataPerPage;
    }

    public void setDataPerPage(int dataPerPage) {
        this.dataPerPage = dataPerPage;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getRows() {
        return super.getRows();
    }

    @Override
    public int getSlots() {
        return super.getSlots();
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }
}

