/*
 * Decompiled with CFR 0.152.
 */
package com.liba.utils.file;

import com.liba.Liba;
import com.liba.utils.MinecraftColor;
import com.liba.utils.coreversion.VersionValidator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class FileChecker {
    HashMap<String, Object> objectHashMap = new HashMap();
    HashMap<String, List<String>> commentsMap = new HashMap();
    File f;
    YamlConfiguration config;
    String filedir;
    String header;

    public FileChecker(String filedir) {
        this.filedir = filedir;
        this.loadFile(filedir);
        this.checkStorage();
    }

    public FileChecker(String filedir, String header) {
        this.filedir = filedir;
        this.header = header;
        this.loadFile(filedir);
        this.checkStorage();
    }

    public void loadFile(String filedir) {
        this.f = new File(filedir);
        if (!this.f.exists()) {
            if (!this.f.getParentFile().exists()) {
                this.f.getParentFile().mkdirs();
            }
            try {
                this.f.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.f);
        if (this.header != null) {
            this.config.options().header(this.header);
            try {
                this.config.save(this.f);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getFormatted(String key, Map<String, String> placeholders) {
        Object object = this.objectHashMap.get(key);
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            string = string.replace(entry.getKey(), entry.getValue());
        }
        return MinecraftColor.format(string);
    }

    public abstract void needle();

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.f);
        this.checkStorage();
    }

    public void addParam(String key, Object object) {
        this.objectHashMap.put(key, object);
    }

    public void addParam(String key, Object object, String ... comments) {
        this.objectHashMap.put(key, object);
        this.commentsMap.put(key, Arrays.asList(comments));
    }

    public boolean setParam(String key, Object object) throws IOException {
        if (this.objectHashMap.containsKey(key)) {
            this.config.set(key, object);
            this.objectHashMap.put(key, object);
            this.config.save(this.f);
            return true;
        }
        return false;
    }

    public double getDouble(String key) {
        return (Double)this.objectHashMap.get(key);
    }

    public String getString(String key) {
        Object object = this.objectHashMap.get(key);
        if (object instanceof String) {
            String string = (String)object;
            string = MinecraftColor.format(string);
            return string;
        }
        return null;
    }

    public List<String> getStringOrList(String key) {
        ArrayList<String> strings = new ArrayList<String>();
        if (this.objectHashMap.get(key) instanceof String) {
            strings.add(this.getString(key));
        }
        if (this.objectHashMap.get(key) instanceof List) {
            strings.addAll(this.getParamList(key));
        }
        return strings;
    }

    public List<String> getStringOrList(String key, Map<String, String> placeholders) {
        ArrayList<String> result = new ArrayList<String>();
        Object raw = this.objectHashMap.get(key);
        if (raw instanceof String) {
            String singleLine = (String)raw;
            result.add(this.applyFormatting(singleLine, placeholders));
        }
        if (raw instanceof List) {
            List list = (List)raw;
            for (Object line : list) {
                if (!(line instanceof String)) continue;
                String str = (String)line;
                result.add(this.applyFormatting(str, placeholders));
            }
        }
        return result;
    }

    private String applyFormatting(String input, Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            input = input.replace(key, value);
        }
        return MinecraftColor.format(input);
    }

    public List<?> getParamList(String key) {
        Object object = this.objectHashMap.get(key);
        ArrayList<String> strings = new ArrayList<String>();
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                string = MinecraftColor.format(string);
                strings.add(i, string);
            }
            return strings;
        }
        return null;
    }

    public <K, V> Map<K, V> getMap(String key, Class<K> keyType, Class<V> valueType) {
        Object obj = this.objectHashMap.get(key);
        Map<K, V> map = this.getKvMap(keyType, valueType, obj);
        for (Map.Entry<K, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof String) {
                String string = (String)entry.getValue();
                entry.setValue(MinecraftColor.format(string));
            }
            if (!(entry.getValue() instanceof List)) continue;
            ArrayList<String> strings = new ArrayList<String>();
            List list = (List)entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                string = MinecraftColor.format(string);
                strings.add(i, string);
            }
            entry.setValue(strings);
        }
        return map;
    }

    private <K, V> Map<K, V> getKvMap(Class<K> keyType, Class<V> valueType, Object obj) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (obj instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)obj;
            for (String subKey : section.getKeys(false)) {
                Object value = section.get(subKey);
                K keyCasted = keyType.cast(subKey);
                V valueCasted = valueType.cast(value);
                map.put(keyCasted, valueCasted);
            }
        }
        return map;
    }

    public boolean getBool(String key) {
        boolean bool = (Boolean)this.objectHashMap.get(key);
        return bool;
    }

    public int getInt(String key) {
        int intvalue = (Integer)this.objectHashMap.get(key);
        return intvalue;
    }

    public String toString() {
        Object string = "";
        for (Map.Entry<String, Object> entry : this.objectHashMap.entrySet()) {
            string = (String)string + entry.getKey() + " " + entry.getValue().toString() + "\n";
        }
        return string;
    }

    public void checkStorage() {
        this.needle();
        boolean changed = false;
        for (Map.Entry<String, Object> entry : this.objectHashMap.entrySet()) {
            if (this.config.contains(entry.getKey())) {
                Object object = this.config.get(entry.getKey());
                this.objectHashMap.put(entry.getKey(), object);
                continue;
            }
            changed = true;
            this.config.set(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.commentsMap.entrySet()) {
            if (!VersionValidator.check("1.17.2", VersionValidator.EventTime.AFTER, Liba.getPlugin())) continue;
            try {
                Method getCommentsMethod = this.config.getClass().getMethod("getComments", String.class);
                List comments = (List)getCommentsMethod.invoke((Object)this.config, entry.getKey());
                if (!comments.isEmpty()) continue;
                Method setCommentsMethod = this.config.getClass().getMethod("setComments", String.class, List.class);
                setCommentsMethod.invoke((Object)this.config, entry.getKey(), entry.getValue());
                changed = true;
            }
            catch (Exception e) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e.", e);
            }
        }
        if (changed) {
            try {
                this.config.save(this.f);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getFiledir() {
        return this.filedir;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }
}

