/*
 * Decompiled with CFR 0.152.
 */
package com.modencore;

import com.liba.Liba;
import com.modencore.chunk.BlockChunk;
import com.modencore.commands.ChunkCommands;
import com.modencore.crafts.PluginCrafts;
import com.modencore.events.ChunkEvents;
import com.modencore.lang.Lang;
import com.modencore.lang.PluginConfig;
import com.modencore.menus.AdminMenu;
import com.modencore.storage.ChunkStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.bukkit.Chunk;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ChunkLoader
extends JavaPlugin {
    static ChunkLoader plugin;
    Liba liba;
    List<BlockChunk> loadedChunk = new ArrayList<BlockChunk>();
    PluginConfig pluginConfig;
    ChunkStorage storage;
    Lang lang;
    HashMap<Player, AdminMenu> adminMenuHashMap = new HashMap();

    public void onEnable() {
        plugin = this;
        this.liba = new Liba((Plugin)this);
        this.lang = new Lang(String.valueOf(this.getDataFolder()) + File.separator + "lang.yml");
        this.lang.checkStorage();
        this.pluginConfig = new PluginConfig();
        this.pluginConfig.load();
        this.liba.registerMetrica(26478);
        this.liba.registerVersionChecker(28, "https://modrinth.com/plugin/chunkloader");
        this.storage = new ChunkStorage();
        this.getServer().getPluginManager().registerEvents((Listener)new ChunkEvents(this.lang), (Plugin)this);
        this.loadedChunk = this.storage.loadALl();
        this.loadedChunk.forEach(BlockChunk::load);
        this.getServer().getPluginCommand("chunkloader").setExecutor((CommandExecutor)new ChunkCommands(this.lang));
        PluginCrafts.register();
    }

    public void onDisable() {
    }

    public static ChunkLoader getPlugin() {
        return plugin;
    }

    public void load(BlockChunk chunk) {
        chunk.load();
        this.loadedChunk.add(chunk);
    }

    public void remove(BlockChunk blockChunk) {
        blockChunk.remove();
        this.loadedChunk.remove(blockChunk);
    }

    public List<BlockChunk> getLoadedChunk() {
        return this.loadedChunk;
    }

    public BlockChunk getBlockChunkChunk(Chunk chunk) {
        Optional<BlockChunk> chunkOptional = this.getLoadedChunk().stream().filter(f -> f.getLocation().getChunk().equals(chunk)).findFirst();
        return chunkOptional.orElse(null);
    }

    public ChunkStorage getStorage() {
        return this.storage;
    }

    public Lang getLang() {
        return this.lang;
    }

    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public void openAdmin(Player player) {
        this.adminMenuHashMap.putIfAbsent(player, new AdminMenu(ChunkLoader.getPlugin().getLang().getString("gui.admin.title"), 27));
        AdminMenu adminMenu = this.adminMenuHashMap.get(player);
        adminMenu.open(player);
    }
}

