/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.chunk;

import com.modencore.ChunkLoader;
import com.modencore.menus.ChunkMenu;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class BlockChunk {
    Location location;
    ChunkMenu menu;
    boolean showChunk;
    int task;
    UUID owner;
    UUID key;

    public BlockChunk(UUID owner, Location location, UUID key) {
        this.location = location;
        this.owner = owner;
        this.key = key;
        this.menu = new ChunkMenu(ChunkLoader.getPlugin().getLang().getString("gui.title"), 9, this);
    }

    public void show() {
        if (!this.showChunk) {
            this.task = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)ChunkLoader.getPlugin(), this::Run, 0L, 20L);
            this.showChunk = true;
        }
    }

    public void Run() {
        World world = this.getLocation().getChunk().getWorld();
        int y = this.getLocation().getBlockY();
        int minX = this.getLocation().getChunk().getX() << 4;
        int minZ = this.getLocation().getChunk().getZ() << 4;
        int maxX = minX + 15;
        int maxZ = minZ + 15;
        for (int x = minX; x <= maxX; ++x) {
            world.spawnParticle(Particle.HAPPY_VILLAGER, (double)x + 0.5, (double)y, (double)minZ + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            world.spawnParticle(Particle.HAPPY_VILLAGER, (double)x + 0.5, (double)y, (double)maxZ + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (int z = minZ; z <= maxZ; ++z) {
            world.spawnParticle(Particle.HAPPY_VILLAGER, (double)minX + 0.5, (double)y, (double)z + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            world.spawnParticle(Particle.HAPPY_VILLAGER, (double)maxX + 0.5, (double)y, (double)z + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void stopShow() {
        if (this.showChunk) {
            Bukkit.getScheduler().cancelTask(this.task);
            this.task = 0;
            this.showChunk = false;
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public ChunkMenu getMenu() {
        return this.menu;
    }

    public void load() {
        this.getLocation().getChunk().setForceLoaded(true);
    }

    public void remove() {
        if (this.showChunk) {
            this.stopShow();
        }
        this.getLocation().getChunk().setForceLoaded(false);
    }

    public boolean isShowChunk() {
        return this.showChunk;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public UUID getKey() {
        return this.key;
    }
}

