/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.commands;

import com.modencore.ChunkLoader;
import com.modencore.crafts.PluginCrafts;
import com.modencore.lang.Lang;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ChunkCommands
implements CommandExecutor,
TabCompleter {
    Lang lang;

    public ChunkCommands(Lang lang) {
        this.lang = lang;
    }

    public boolean onCommand(CommandSender cs, Command cmd, String s, String[] args) {
        if (cmd.getName().equalsIgnoreCase("chunkloader") && (cs.hasPermission("*") || cs.hasPermission("chunkloader.admin")) && args.length > 0) {
            if (args.length == 1 && args[0].equalsIgnoreCase("admin")) {
                ChunkLoader.getPlugin().openAdmin((Player)cs);
                return true;
            }
            if (args[0].equalsIgnoreCase("giveblock")) {
                if (args.length == 2) {
                    Player p = Bukkit.getPlayer((String)args[1]);
                    if (p == null || !p.isOnline()) {
                        cs.sendMessage(this.lang.prefix("playernotonline"));
                        return true;
                    }
                    p.getInventory().addItem(new ItemStack[]{PluginCrafts.CHUNK_BLOCK.getCraft().getItem()});
                    cs.sendMessage(this.lang.prefix("successgiveblock"));
                    return true;
                }
                if (cs instanceof Player) {
                    Player player = (Player)cs;
                    player.getInventory().addItem(new ItemStack[]{PluginCrafts.CHUNK_BLOCK.getCraft().getItem()});
                    cs.sendMessage(this.lang.prefix("successgiveblock"));
                }
                return true;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                this.lang.reload();
                cs.sendMessage(this.lang.prefix("reloadmessage"));
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender cs, Command cmd, String alias, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("chunkloader")) {
            return List.of();
        }
        if (cs.hasPermission("*") || cs.hasPermission("chunkloader.admin")) {
            if (args.length == 1) {
                return List.of("giveblock", "reload", "admin").stream().filter(s -> s.startsWith(args[0].toLowerCase())).toList();
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("giveblock")) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).toList();
            }
        }
        return List.of();
    }
}

