/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.lang;

import com.modencore.ChunkLoader;
import com.modencore.crafts.PluginCrafts;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ShapedRecipe;

public class PluginConfig {
    File file = new File(ChunkLoader.getPlugin().getDataFolder(), "config.yml");
    FileConfiguration config;
    boolean craft;
    ShapedRecipe recipe;

    public PluginConfig() {
        if (!this.file.exists()) {
            ChunkLoader.getPlugin().saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void load() {
        ConfigurationSection craftsection = this.config.getConfigurationSection("craft");
        if (craftsection != null) {
            this.craft = craftsection.getBoolean("chunkblock-havecraft");
            ShapedRecipe shapedRecipe = new ShapedRecipe(PluginCrafts.CHUNK_BLOCK.getCraft().getKey(), PluginCrafts.CHUNK_BLOCK.getCraft().getItem());
            List rawShape = craftsection.getStringList("shape");
            HashMap<String, Character> materialMap = new HashMap<String, Character>();
            ArrayList<String> newShape = new ArrayList<String>();
            char symbol = 'A';
            for (String string : rawShape) {
                String[] parts = string.trim().split("\\s+");
                StringBuilder sb = new StringBuilder();
                for (String part : parts) {
                    if (!part.equalsIgnoreCase("AIR")) {
                        materialMap.putIfAbsent(part, Character.valueOf(symbol));
                        sb.append(materialMap.get(part));
                        if (((Character)materialMap.get(part)).charValue() != symbol) continue;
                        symbol = (char)(symbol + '\u0001');
                        continue;
                    }
                    sb.append(" ");
                }
                newShape.add(sb.toString());
            }
            shapedRecipe.shape(newShape.toArray(new String[0]));
            for (Map.Entry entry : materialMap.entrySet()) {
                Bukkit.broadcastMessage((String)((String)entry.getKey()));
                Material mat = Material.valueOf((String)((String)entry.getKey()).toUpperCase());
                shapedRecipe.setIngredient(((Character)entry.getValue()).charValue(), mat);
            }
            this.recipe = shapedRecipe;
        }
    }

    public boolean isCraft() {
        return this.craft;
    }

    public ShapedRecipe getRecipe() {
        return this.recipe;
    }
}

