/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.menus;

import com.liba.menu.Menu;
import com.liba.menu.MenuSlot;
import com.liba.menu.buttons.BooleanButton;
import com.liba.menu.buttons.ButtonType;
import com.liba.menu.buttons.TextButton;
import com.liba.utils.ItemUtil;
import com.modencore.ChunkLoader;
import com.modencore.chunk.BlockChunk;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ChunkMenu
extends Menu {
    BlockChunk blockChunk;

    public ChunkMenu(String title, int size, BlockChunk blockChunk) {
        super(title, size);
        this.blockChunk = blockChunk;
        this.setTopInventoryClick((p, e) -> e.setCancelled(true));
        this.setBottomInventoryClick((p, e) -> e.setCancelled(true));
        this.setItems();
    }

    @Override
    public void setItems() {
        TextButton ownerbutton = new TextButton(ItemUtil.create(new ItemStack(Material.PLAYER_HEAD), ChunkLoader.getPlugin().getLang().getFormatted("gui.owneritem.title", Map.of("{player}", Bukkit.getOfflinePlayer((UUID)this.blockChunk.getOwner()).getName())), ChunkLoader.getPlugin().getLang().getStringOrList("gui.owneritem.description", Map.of("{player}", Bukkit.getOfflinePlayer((UUID)this.blockChunk.getOwner()).getName()))));
        this.addSlot(2, new MenuSlot(ownerbutton, (p, e) -> {}));
        BooleanButton booleanButton = new BooleanButton(ItemUtil.create(new ItemStack(Material.GREEN_WOOL), ChunkLoader.getPlugin().getLang().getString("gui.enablebutton.title"), ChunkLoader.getPlugin().getLang().getStringOrList("gui.enablebutton.description")), ItemUtil.create(new ItemStack(Material.RED_WOOL), ChunkLoader.getPlugin().getLang().getString("gui.disablebutton.title"), ChunkLoader.getPlugin().getLang().getStringOrList("gui.disablebutton.description")), this.blockChunk.isShowChunk());
        booleanButton.setButtonType(ButtonType.updatable);
        this.addSlot(4, new MenuSlot(booleanButton, (p, e) -> {
            if (this.blockChunk.isShowChunk()) {
                this.blockChunk.stopShow();
            } else {
                this.blockChunk.show();
            }
            booleanButton.setVariable(this.blockChunk.isShowChunk());
        }));
        TextButton textButton = new TextButton(ItemUtil.create(new ItemStack(Material.PAPER), ChunkLoader.getPlugin().getLang().getString("gui.thirditem.title"), ChunkLoader.getPlugin().getLang().getStringOrList("gui.thirditem.description")));
        this.addSlot(6, new MenuSlot(textButton, (p, e) -> {}));
    }
}

