/*
 * Decompiled with CFR 0.152.
 */
package com.modencore.storage;

import com.modencore.ChunkLoader;
import com.modencore.chunk.BlockChunk;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;

public class ChunkStorage {
    File file = new File(String.valueOf(ChunkLoader.getPlugin().getDataFolder()) + File.separator + "chunks" + File.separator);

    public ChunkStorage() {
        if (!this.file.exists()) {
            this.file.mkdirs();
        }
    }

    public void save(BlockChunk blockChunk) {
        File f = new File(this.file.getAbsolutePath() + File.separator + blockChunk.getKey().toString() + ".yml");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)f);
        config.set("location.x", (Object)blockChunk.getLocation().getBlockX());
        config.set("location.y", (Object)blockChunk.getLocation().getBlockY());
        config.set("location.z", (Object)blockChunk.getLocation().getBlockZ());
        config.set("location.world", (Object)blockChunk.getLocation().getWorld().getName());
        config.set("owner", (Object)blockChunk.getOwner().toString());
        try {
            config.save(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BlockChunk load(String filename) {
        File f = new File(this.file.getAbsolutePath() + File.separator + filename);
        if (f.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)f);
            int x = config.getInt("location.x");
            int y = config.getInt("location.y");
            int z = config.getInt("location.z");
            World world = Bukkit.getWorld((String)config.getString("location.world"));
            UUID owner = UUID.fromString(config.getString("owner"));
            Location location = new Location(world, (double)x, (double)y, (double)z);
            return new BlockChunk(owner, location, UUID.fromString(filename.split("\\.")[0]));
        }
        return null;
    }

    public List<BlockChunk> loadALl() {
        File[] files = this.file.listFiles();
        ArrayList<BlockChunk> blockChunks = new ArrayList<BlockChunk>();
        if (files != null) {
            for (File f : files) {
                String filename = f.getName();
                BlockChunk blockChunk = this.load(filename);
                if (blockChunk == null) continue;
                blockChunks.add(blockChunk);
            }
        }
        return blockChunks;
    }

    public void remove(String key) {
        File f = new File(this.file.getAbsolutePath() + File.separator + key + ".yml");
        if (f.exists()) {
            f.delete();
        }
    }
}

