/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.gui.widget;

import com.google.common.collect.Lists;
import fi.dy.masa.malilib.config.gui.ConfigOptionChangeListenerTextField;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetContainer;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Vec3i;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.util.IntegerUtil;

public class WidgetVec3iEdit
extends WidgetContainer {
    public static TextFieldMaker textFieldMaker = (x, y, width, height, initialValue, textFieldListenerFunction) -> {
        GuiTextFieldInteger field = new GuiTextFieldInteger(x, y, width, height, Minecraft.getInstance().font);
        field.setMaxLength(11);
        field.setValue(String.valueOf(initialValue));
        ConfigOptionChangeListenerTextField textFieldListener = (ConfigOptionChangeListenerTextField)textFieldListenerFunction.apply(field);
        return new TextFieldWrapper((GuiTextFieldGeneric)field, (ITextFieldListener)textFieldListener);
    };
    private final String xLabel;
    private final String yLabel;
    private final String zLabel;
    protected final Vec3i defaultValue;
    protected final Consumer<Vec3i> valueApplier;
    protected Vec3i initialValue;
    protected Vec3i lastAppliedValue;
    protected TextFieldWrapper<GuiTextFieldGeneric> xTextField;
    protected TextFieldWrapper<GuiTextFieldGeneric> yTextField;
    protected TextFieldWrapper<GuiTextFieldGeneric> zTextField;

    public WidgetVec3iEdit(int x, int y, int width, int height, Vec3i initialValue, Vec3i defaultValue, Consumer<Vec3i> valueApplier) {
        this(x, y, width, height, initialValue, defaultValue, valueApplier, "x:", "y:", "z:");
    }

    public WidgetVec3iEdit(int x, int y, int width, int height, Vec3i initialValue, Vec3i defaultValue, Consumer<Vec3i> valueApplier, String xLabel, String yLabel, String zLabel) {
        super(x, y, width, height);
        this.defaultValue = defaultValue;
        this.initialValue = initialValue;
        this.lastAppliedValue = initialValue;
        this.valueApplier = valueApplier;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.zLabel = zLabel;
        this.init(x, y, width, height);
    }

    protected void init(int x, int y, int width, int height) {
        ButtonGeneric resetButton = this.createResetButton(x + width - 34, y);
        this.createTextFields(x, y + 1, width - 36, 17, resetButton);
        this.updateResetButtonState(resetButton);
    }

    protected ButtonGeneric createResetButton(int x, int y) {
        ButtonGeneric resetButton = new ButtonGeneric(x, y, -1, 20, I18n.tr("malilib.gui.button.reset.caps"), new String[0]);
        ListenerResetConfig listenerReset = new ListenerResetConfig(resetButton, this);
        resetButton.setActionListener((IButtonActionListener)listenerReset);
        this.addButton((ButtonBase)resetButton, listenerReset);
        return resetButton;
    }

    protected void updateResetButtonState(ButtonGeneric resetButton) {
        resetButton.setEnabled(!this.getVec3iValue().equals((Object)this.defaultValue));
    }

    protected void createTextFields(int x, int y, int width, int height, ButtonGeneric resetButton) {
        int xyTextFieldWidth = width / 3;
        int zTextFieldWidth = width - xyTextFieldWidth * 2;
        this.addLabel(x, y, 20, 20, -1, new String[]{this.xLabel});
        this.xTextField = textFieldMaker.make(x + 15, y, xyTextFieldWidth - 20, height, this.initialValue.getX(), textField -> new ChangeListenerTextField((GuiTextFieldGeneric)textField, (ButtonBase)resetButton, String.valueOf(this.defaultValue.getX())));
        this.addLabel(x += xyTextFieldWidth, y, 20, 20, -1, new String[]{this.yLabel});
        this.yTextField = textFieldMaker.make(x + 15, y, xyTextFieldWidth - 20, height, this.initialValue.getY(), textField -> new ChangeListenerTextField((GuiTextFieldGeneric)textField, (ButtonBase)resetButton, String.valueOf(this.defaultValue.getY())));
        this.addLabel(x += xyTextFieldWidth, y, 20, 20, -1, new String[]{this.zLabel});
        this.zTextField = textFieldMaker.make(x + 15, y, zTextFieldWidth - 20, height, this.initialValue.getZ(), textField -> new ChangeListenerTextField((GuiTextFieldGeneric)textField, (ButtonBase)resetButton, String.valueOf(this.defaultValue.getZ())));
    }

    public boolean wasConfigModified() {
        Vec3i newValue = this.getVec3iValue();
        return !newValue.equals((Object)this.initialValue);
    }

    public void applyNewValueToConfig() {
        Vec3i newValue = this.getVec3iValue();
        if (this.valueApplier != null) {
            this.valueApplier.accept(newValue);
        }
        this.lastAppliedValue = newValue;
    }

    public Vec3i getVec3iValue() {
        int x = IntegerUtil.parseIntegerWithBound(this.xTextField.getTextField().getValue());
        int y = IntegerUtil.parseIntegerWithBound(this.yTextField.getTextField().getValue());
        int z = IntegerUtil.parseIntegerWithBound(this.zTextField.getTextField().getValue());
        return new Vec3i(x, y, z);
    }

    protected List<TextFieldWrapper<GuiTextFieldGeneric>> getTextFields() {
        return Lists.newArrayList((Object[])new TextFieldWrapper[]{this.xTextField, this.yTextField, this.zTextField});
    }

    public void render(int mouseX, int mouseY, boolean selected, GuiGraphics poseStackOrGuiGraphics) {
        this.drawTextFields(mouseX, mouseY, poseStackOrGuiGraphics);
        super.render(mouseX, mouseY, selected, poseStackOrGuiGraphics);
    }

    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        boolean ret = false;
        Function<TextFieldWrapper, Boolean> mouseClickImpl = wrapper -> {
            if (wrapper == null) {
                return false;
            }
            return wrapper.getTextField().mouseClicked((double)mouseX, (double)mouseY, mouseButton);
        };
        ret |= mouseClickImpl.apply(this.xTextField).booleanValue();
        ret |= mouseClickImpl.apply(this.yTextField).booleanValue();
        ret |= mouseClickImpl.apply(this.zTextField).booleanValue();
        for (WidgetBase widget : this.subWidgets) {
            ret |= widget.isMouseOver(mouseX, mouseY) && widget.onMouseClicked(mouseX, mouseY, mouseButton);
        }
        return ret;
    }

    public boolean onKeyTypedImpl(int keyCode, int scanCode, int modifiers) {
        Function<TextFieldWrapper, Boolean> keyTypedImpl = wrapper -> {
            if (wrapper == null || !wrapper.isFocused()) {
                return false;
            }
            if (keyCode == 257) {
                this.applyNewValueToConfig();
                return true;
            }
            return wrapper.onKeyTyped(keyCode, scanCode, modifiers);
        };
        return keyTypedImpl.apply(this.xTextField) != false || keyTypedImpl.apply(this.yTextField) != false || keyTypedImpl.apply(this.zTextField) != false;
    }

    protected boolean onCharTypedImpl(char charIn, int modifiers) {
        Function<TextFieldWrapper, Boolean> charTypedImpl = wrapper -> {
            if (wrapper == null) {
                return false;
            }
            return wrapper.onCharTyped(charIn, modifiers);
        };
        return charTypedImpl.apply(this.xTextField) != false || charTypedImpl.apply(this.yTextField) != false || charTypedImpl.apply(this.zTextField) != false;
    }

    protected void drawTextFields(int mouseX, int mouseY, GuiGraphics poseStackOrGuiGraphics) {
        if (this.xTextField == null || this.yTextField == null || this.zTextField == null) {
            return;
        }
        Consumer<TextFieldWrapper> drawTextField = wrapper -> wrapper.getTextField().render(poseStackOrGuiGraphics, mouseX, mouseY, 0.0f);
        drawTextField.accept(this.xTextField);
        drawTextField.accept(this.yTextField);
        drawTextField.accept(this.zTextField);
    }

    private static class ListenerResetConfig
    implements IButtonActionListener {
        private final ButtonGeneric resetButton;
        private final WidgetVec3iEdit parent;

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            BiConsumer<Function, Function> transformer = (wrapperTransformer, vec3iTransformer) -> ((TextFieldWrapper)wrapperTransformer.apply(this.parent)).getTextField().setValue(String.valueOf(vec3iTransformer.apply(this.parent.defaultValue)));
            transformer.accept(w -> w.xTextField, Vec3i::getX);
            transformer.accept(w -> w.yTextField, Vec3i::getY);
            transformer.accept(w -> w.zTextField, Vec3i::getZ);
            this.resetButton.setEnabled(!this.parent.getVec3iValue().equals((Object)this.parent.defaultValue));
        }

        @Generated
        public ListenerResetConfig(ButtonGeneric resetButton, WidgetVec3iEdit parent) {
            this.resetButton = resetButton;
            this.parent = parent;
        }
    }

    @FunctionalInterface
    public static interface TextFieldMaker {
        public TextFieldWrapper<GuiTextFieldGeneric> make(int var1, int var2, int var3, int var4, int var5, Function<GuiTextFieldGeneric, ConfigOptionChangeListenerTextField> var6);
    }

    public static class ChangeListenerTextField
    extends ConfigOptionChangeListenerTextField {
        protected final String defaultValue;

        public ChangeListenerTextField(GuiTextFieldGeneric textField, ButtonBase resetButton, String defaultValue) {
            super(null, textField, resetButton);
            this.defaultValue = defaultValue;
        }

        public boolean onTextChange(GuiTextFieldGeneric textField) {
            this.buttonReset.setEnabled(!this.textField.getValue().equals(this.defaultValue));
            return false;
        }
    }
}

