/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.compat.minecraft.world.item;

import java.util.Objects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.impl.compat.minecraft.world.item.ItemStackCompatImpl;
import top.hendrixshen.magiclib.util.collect.Provider;

public interface ItemStackCompat
extends Provider<ItemStack> {
    @NotNull
    public static ItemStackCompat of(@NotNull ItemStack itemStack) {
        return new ItemStackCompatImpl(itemStack);
    }

    public static boolean tagMatches(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.isEmpty() && itemStack2.isEmpty()) {
            return true;
        }
        if (itemStack.isEmpty() || itemStack2.isEmpty()) {
            return false;
        }
        if (itemStack.getTag() == null && itemStack2.getTag() != null) {
            return false;
        }
        return Objects.equals(itemStack.getTag(), itemStack2.getTag());
    }

    public static boolean isSame(ItemStack itemStack, ItemStack itemStack2) {
        return ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)itemStack2);
    }

    public static boolean isSameIgnoreDurability(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == itemStack2) {
            return true;
        }
        if (itemStack.isEmpty() && itemStack2.isEmpty()) {
            return false;
        }
        if (itemStack.isDamageableItem()) {
            return !itemStack2.isEmpty() && itemStack.is(itemStack2.getItem());
        }
        return ItemStackCompat.isSame(itemStack, itemStack2);
    }

    public static boolean isSameItemSameTags(@NotNull ItemStack itemStack, @NotNull ItemStack itemStack2) {
        return ItemStack.isSameItemSameTags((ItemStack)itemStack, (ItemStack)itemStack2);
    }

    public static boolean isSameItemSameTagsIgnoreDurability(@NotNull ItemStack itemStack, @NotNull ItemStack itemStack2) {
        return ItemStackCompat.isSameIgnoreDurability(itemStack, itemStack2) && ItemStackCompat.tagMatches(itemStack, itemStack2);
    }

    public boolean is(Item var1);
}

