/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.render.context;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import top.hendrixshen.magiclib.api.render.matrix.MatrixStack;
import top.hendrixshen.magiclib.impl.render.context.LevelRenderContextImpl;
import top.hendrixshen.magiclib.impl.render.context.RenderContextImpl;
import top.hendrixshen.magiclib.impl.render.matrix.MinecraftPoseStack;
import top.hendrixshen.magiclib.util.minecraft.render.RenderContextUtil;

public interface RenderContext {
    @NotNull
    public static RenderContext of(@NotNull PoseStack poseStack) {
        return new RenderContextImpl(RenderContextUtil.createDrawContext(poseStack), new MinecraftPoseStack(poseStack));
    }

    @NotNull
    public static LevelRenderContextImpl createWorldRenderContext(@NotNull PoseStack matrixStack) {
        return new LevelRenderContextImpl(RenderContextUtil.createDrawContext(matrixStack), new MinecraftPoseStack(matrixStack));
    }

    public static RenderContext of(@NotNull GuiGraphics guiGraphics) {
        return new RenderContextImpl(guiGraphics, new MinecraftPoseStack(guiGraphics.pose()));
    }

    public GuiGraphics getGuiComponent();

    public MatrixStack getMatrixStack();

    public void pushMatrix();

    public void popMatrix();

    public void translate(double var1, double var3, double var5);

    public void scale(double var1, double var3, double var5);

    public void mulPoseMatrix(Matrix4f var1);
}

