/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.platform;

import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.platform.DistType;
import top.hendrixshen.magiclib.api.platform.PlatformType;
import top.hendrixshen.magiclib.api.platform.adapter.ModContainerAdapter;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public interface Platform {
    public Path getGameFolder();

    public Path getConfigFolder();

    public Path getModsFolder();

    public PlatformType getPlatformType();

    default public String getPlatformName() {
        return this.getPlatformType().getName();
    }

    public DistType getCurrentDistType();

    public boolean matchesDist(DistType var1);

    public boolean isModLoaded(String var1);

    public boolean isModExist(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getModName(String modIdentifier) {
        return this.getMod(modIdentifier).map(mod -> mod.getModMetaData().getName()).orElse("?");
    }

    default public String getModVersion(String modIdentifier) {
        return this.getMod(modIdentifier).map(mod -> mod.getModMetaData().getVersion()).orElse("?");
    }

    public ValueContainer<ModContainerAdapter> getMod(String var1);

    public Collection<ModContainerAdapter> getMods();

    public Collection<String> getModIds();

    @ApiStatus.Experimental
    @Nullable
    public String getNamedMappingName();
}

