/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.fabric;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.util.fabric.ExceptionUtil;

public class UrlUtil {
    public static final Path LOADER_CODE_SOURCE = UrlUtil.getCodeSource(UrlUtil.class);

    @NotNull
    public static Path asPath(@NotNull URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Nullable
    public static Path getCodeSource(@NotNull Class<?> cls) {
        CodeSource cs = cls.getProtectionDomain().getCodeSource();
        if (cs == null) {
            return null;
        }
        return UrlUtil.asPath(cs.getLocation());
    }
}

