/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.mixin.minecraft.network.hook;

import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.hendrixshen.magiclib.api.network.packet.PacketType;
import top.hendrixshen.magiclib.api.network.packet.ServerboundPacketHandler;
import top.hendrixshen.magiclib.impl.network.packet.MagicCustomPayload;
import top.hendrixshen.magiclib.impl.network.packet.MagicPacketRegistry;
import top.hendrixshen.magiclib.impl.network.packet.PacketHandlerContextImpl;
import top.hendrixshen.magiclib.impl.network.packet.RegistryEntry;

@Mixin(value={ServerCommonPacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin {
    @Inject(method={"handleCustomPayload(Lnet/minecraft/network/protocol/common/ServerboundCustomPayloadPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleServerboundCustomPayload(ServerboundCustomPayloadPacket packet, CallbackInfo ci) {
        ResourceLocation identifier = packet.payload().type().id();
        PacketType type = PacketType.of(identifier);
        RegistryEntry entry = MagicPacketRegistry.SERVERBOUND_GAME.getEntry(type);
        if (entry == null) {
            return;
        }
        Object object = packet.payload();
        if (object instanceof MagicCustomPayload) {
            MagicCustomPayload mcp = (MagicCustomPayload)object;
            object = this;
            if (object instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl self = (ServerGamePacketListenerImpl)object;
                ServerGamePacketListenerImplMixin.handleCustomPayload(mcp, entry.getHandler(), self);
                ci.cancel();
            }
        }
    }

    @Unique
    private static <P> void handleCustomPayload(MagicCustomPayload<P> payload, ServerboundPacketHandler<P> handler, ServerGamePacketListenerImpl self) {
        handler.handle(payload.getPacket(), new PacketHandlerContextImpl.Serverbound(self));
    }
}

