/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.dependency;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.dependency.DependencyCheckException;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.api.platform.DistType;
import top.hendrixshen.magiclib.api.platform.adapter.ModContainerAdapter;
import top.hendrixshen.magiclib.api.platform.adapter.ModMetaDataAdapter;
import top.hendrixshen.magiclib.impl.dependency.DependenciesContainer;
import top.hendrixshen.magiclib.impl.gui.fabric.FabricGuiEntry;
import top.hendrixshen.magiclib.util.DependencyUtil;
import top.hendrixshen.magiclib.util.MiscUtil;
import top.hendrixshen.magiclib.util.collect.InfoNode;

@ApiStatus.Internal
public final class EntryPointDependency {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final AtomicBoolean isChecked = new AtomicBoolean();

    public void check() {
        if (this.isChecked.get()) {
            throw new IllegalStateException("Re-trigger EntryPointDependency check.");
        }
        ArrayList exceptions = Lists.newArrayList();
        for (ModContainerAdapter mod : MagicLib.getInstance().getCurrentPlatform().getMods()) {
            for (ClassNode entryPoint : mod.getModEntryPoint().getMagicEntryPoints()) {
                exceptions.add(this.check(mod.getModMetaData(), entryPoint));
            }
        }
        exceptions.stream().filter(Objects::nonNull).reduce((a, b) -> new DependencyCheckException(a.getMessage() + b.getMessage())).ifPresent(e -> {
            e.setStackTrace(new StackTraceElement[0]);
            FabricGuiEntry.displayCriticalError(e, true);
        });
        this.isChecked.set(true);
    }

    @Nullable
    private DependencyCheckException check(ModMetaDataAdapter modMetaDataAdapter, ClassNode entryPoint) {
        ArrayList dependencies = Lists.newArrayList();
        if (MagicLib.getInstance().getCurrentPlatform().getCurrentDistType().matches(DistType.CLIENT)) {
            dependencies.addAll(this.getDependencies("onInitializeClient", entryPoint));
        } else if (MagicLib.getInstance().getCurrentPlatform().getCurrentDistType().matches(DistType.SERVER)) {
            dependencies.addAll(this.getDependencies("onInitializeServer", entryPoint));
        }
        dependencies.addAll(this.getDependencies("onInitialize", entryPoint));
        if (dependencies.isEmpty() || dependencies.stream().anyMatch(DependenciesContainer::isSatisfied)) {
            return null;
        }
        InfoNode rootNode = new InfoNode(null, I18n.tr("magiclib.dependency.checker.entrypoint.title", modMetaDataAdapter.getName(), modMetaDataAdapter.getModId(), modMetaDataAdapter.getVersion()));
        MiscUtil.generateDependencyCheckMessage(dependencies, rootNode);
        return new DependencyCheckException("\n" + rootNode);
    }

    @NotNull
    private List<DependenciesContainer<Object>> getDependencies(String name, @NotNull ClassNode entryPoint) {
        for (MethodNode method : entryPoint.methods) {
            if (!method.name.equals(name) || !method.desc.equals("()V")) continue;
            return DependencyUtil.parseDependencies(method, null);
        }
        return Collections.emptyList();
    }

    @Generated
    private EntryPointDependency() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static EntryPointDependency getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    EntryPointDependency actualValue = new EntryPointDependency();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (EntryPointDependency)($value == instance ? null : $value);
    }
}

