/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.option;

import com.google.gson.JsonElement;
import fi.dy.masa.malilib.config.options.ConfigBase;
import lombok.Generated;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.ApiStatus;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.malilib.config.option.ConfigVec3i;
import top.hendrixshen.magiclib.util.minecraft.serializable.Vec3iSerializer;

@ApiStatus.Experimental
public class MagicConfigVec3i
extends ConfigBase<MagicConfigVec3i>
implements ConfigVec3i {
    public static final Vec3iSerializer vec3iSerializer = new Vec3iSerializer();
    private final String translationPrefix;
    private final Vec3i defaultVec3iValue;
    private int x;
    private int y;
    private int z;

    public MagicConfigVec3i(String translationPrefix, String name) {
        this(translationPrefix, name, Vec3i.ZERO);
    }

    public MagicConfigVec3i(String translationPrefix, String name, Vec3i defaultValue) {
        super(null, name, String.format("%s.config.option.%s.comment", translationPrefix, name));
        this.translationPrefix = translationPrefix;
        this.defaultVec3iValue = defaultValue;
        this.x = this.defaultVec3iValue.getX();
        this.y = this.defaultVec3iValue.getY();
        this.z = this.defaultVec3iValue.getZ();
    }

    @Override
    public String getPrettyName() {
        return ConfigVec3i.super.getPrettyName();
    }

    @Override
    public String getConfigGuiDisplayName() {
        return ConfigVec3i.super.getConfigGuiDisplayName();
    }

    public boolean isModified() {
        return this.x != this.defaultVec3iValue.getX() || this.y != this.defaultVec3iValue.getY() || this.z != this.defaultVec3iValue.getZ();
    }

    public void resetToDefault() {
        this.x = this.defaultVec3iValue.getX();
        this.y = this.defaultVec3iValue.getY();
        this.z = this.defaultVec3iValue.getZ();
    }

    public void setValueFromJsonElement(JsonElement element) {
        Vec3i oldValue = this.getVec3i();
        try {
            Vec3i vec3i = vec3iSerializer.deserialize(element.getAsJsonObject());
            this.setVec3i(vec3i);
        }
        catch (Exception e) {
            MagicLib.getLogger().warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
        if (!oldValue.equals((Object)this.getVec3i())) {
            this.onValueChanged(true);
        }
    }

    public JsonElement getAsJsonElement() {
        return vec3iSerializer.serialize(this.getVec3i());
    }

    public void onValueChanged() {
        this.onValueChanged(false);
    }

    @Override
    public void onValueChanged(boolean fromFile) {
        super.onValueChanged();
        if (!fromFile && this.getMagicContainer().shouldStatisticValueChange()) {
            this.updateStatisticOnUse();
        }
    }

    @Override
    @Generated
    public String getTranslationPrefix() {
        return this.translationPrefix;
    }

    @Override
    @Generated
    public Vec3i getDefaultVec3iValue() {
        return this.defaultVec3iValue;
    }

    @Override
    @Generated
    public int getX() {
        return this.x;
    }

    @Override
    @Generated
    public int getY() {
        return this.y;
    }

    @Override
    @Generated
    public int getZ() {
        return this.z;
    }

    @Override
    @Generated
    public void setX(int x) {
        this.x = x;
    }

    @Override
    @Generated
    public void setY(int y) {
        this.y = y;
    }

    @Override
    @Generated
    public void setZ(int z) {
        this.z = z;
    }
}

