/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.platform;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import cpw.mods.modlauncher.api.INameMappingService;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.MagicLibProperties;
import top.hendrixshen.magiclib.api.platform.DistType;
import top.hendrixshen.magiclib.api.platform.Platform;
import top.hendrixshen.magiclib.api.platform.PlatformType;
import top.hendrixshen.magiclib.api.platform.adapter.ModContainerAdapter;
import top.hendrixshen.magiclib.impl.platform.adapter.NeoForgeLoadingModList;
import top.hendrixshen.magiclib.impl.platform.adapter.NeoForgeModContainer;
import top.hendrixshen.magiclib.impl.platform.adapter.NeoForgeModList;
import top.hendrixshen.magiclib.util.VersionUtil;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public final class NeoForgePlatformImpl
implements Platform {
    private static final AtomicReference<Object> instance = new AtomicReference();
    public static final ImmutableBiMap<DistType, Dist> distTypeMappings = ImmutableBiMap.of((Object)((Object)DistType.CLIENT), (Object)Dist.CLIENT, (Object)((Object)DistType.SERVER), (Object)Dist.DEDICATED_SERVER);
    private final Map<String, ModContainerAdapter> modMap = Maps.newConcurrentMap();

    @Override
    public Path getGameFolder() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Path getModsFolder() {
        return FMLPaths.MODSDIR.get();
    }

    @Override
    public PlatformType getPlatformType() {
        return PlatformType.NEOFORGE;
    }

    @Override
    public DistType getCurrentDistType() {
        return this.getDistType(this.getCurrentEnvType());
    }

    @Override
    public boolean matchesDist(DistType distType) {
        return this.getCurrentDistType().matches(distType);
    }

    @Override
    public boolean isModLoaded(String modIdentifier) {
        return ModList.get().isLoaded(modIdentifier);
    }

    @Override
    public boolean isModExist(String modIdentifier) {
        return NeoForgeLoadingModList.getInstance().getModFileById(modIdentifier).isPresent();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return ClassLoader.getSystemClassLoader().getResource("net/minecraft/DetectedVersion.class") == null;
    }

    @Override
    public String getModName(String modIdentifier) {
        return NeoForgeModList.getInstance().getModFileById(modIdentifier).or(() -> NeoForgeLoadingModList.getInstance().getModFileById(modIdentifier)).orElseThrow(() -> new IllegalStateException("Access ModList too early!")).getMods().stream().filter(modInfo -> modInfo.getModId().equals(modIdentifier)).findFirst().map(IModInfo::getDisplayName).orElse("?");
    }

    @Override
    public String getModVersion(String modIdentifier) {
        return NeoForgeModList.getInstance().getModFileById(modIdentifier).or(() -> NeoForgeLoadingModList.getInstance().getModFileById(modIdentifier)).orElseThrow(() -> new IllegalStateException("Access ModList too early!")).getMods().stream().filter(modInfo -> modInfo.getModId().equals(modIdentifier)).findFirst().map(iModInfo -> iModInfo.getVersion().toString()).orElse("?");
    }

    @Override
    public ValueContainer<ModContainerAdapter> getMod(String modIdentifier) {
        return ValueContainer.ofNullable(this.modMap.get(modIdentifier)).or(() -> {
            try {
                ModContainerAdapter mod = NeoForgeModContainer.of(modIdentifier);
                this.modMap.put(modIdentifier, mod);
                return ValueContainer.of(mod);
            }
            catch (Exception e) {
                return ValueContainer.empty();
            }
        });
    }

    @Override
    public Collection<ModContainerAdapter> getMods() {
        for (IModInfo info : ModList.get().getMods()) {
            this.getMod(info.getModId());
        }
        return this.modMap.values();
    }

    @Override
    public Collection<String> getModIds() {
        return NeoForgeModList.getInstance().getMods().or(() -> NeoForgeLoadingModList.getInstance().getMods()).orElseThrow(() -> new IllegalStateException("Access ModList too early!")).stream().map(IModInfo::getModId).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public String getNamedMappingName() {
        String methodName;
        String name = MagicLibProperties.DEV_MAPPING_NAME.getStringValue();
        if (name != null) {
            return name;
        }
        String mcVer = MagicLib.getInstance().getCurrentPlatform().getModVersion("minecraft");
        if (VersionUtil.isVersionSatisfyPredicate(mcVer, ">1.20.5-")) {
            return this.isDevelopmentEnvironment() ? "mojang" : null;
        }
        String intermediaryMethodName = VersionUtil.isVersionSatisfyPredicate(mcVer, ">1.17-") ? "m_91341_" : "func_230150_b_";
        switch (methodName = ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)intermediaryMethodName)) {
            case "updateTitle": {
                return "mojang";
            }
            case "updateWindowTitle": {
                return "yarn";
            }
            case "setDefaultMinecraftTitle": {
                return "mcp";
            }
            case "m_91341_": 
            case "func_230150_b_": {
                return null;
            }
        }
        return "unknown";
    }

    public Dist getCurrentEnvType() {
        boolean clientAvailable = ClassLoader.getSystemClassLoader().getResource("net/minecraft/client/main/Main.class") != null;
        return clientAvailable ? Dist.CLIENT : Dist.DEDICATED_SERVER;
    }

    public DistType getDistType(Dist envType) {
        return (DistType)((Object)distTypeMappings.inverse().get((Object)envType));
    }

    public Dist getDist(DistType sideType) {
        return (Dist)distTypeMappings.get((Object)sideType);
    }

    @Generated
    private NeoForgePlatformImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Platform getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    NeoForgePlatformImpl actualValue = new NeoForgePlatformImpl();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (Platform)($value == instance ? null : $value);
    }
}

