/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.i18n.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.i18n.LanguageProvider;
import top.hendrixshen.magiclib.util.JsonUtil;

public class FileLanguageProvider
implements LanguageProvider {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Map<String, List<Path>> files = Maps.newConcurrentMap();

    @Override
    public void init() {
        try {
            for (URL resource : Collections.list(this.getClassLoader().getResources("assets"))) {
                if (!resource.getProtocol().equals("file") && !resource.getProtocol().equals("union")) continue;
                Path path = Paths.get(resource.toURI());
                Files.walkFileTree(path, new LanguageFileVisitor(path, this.files, false));
            }
        }
        catch (IOException | URISyntaxException e) {
            MagicLib.getLogger().error("Failed to load language file.", (Throwable)e);
        }
    }

    @Override
    public void reload() {
        this.files.clear();
        this.init();
    }

    @Override
    public void reload(String LanguageCode) {
        this.reload();
    }

    @Override
    public void loadLanguage(String languageCode) {
    }

    @Override
    public Map<String, String> getLanguage(String languageCode) {
        ConcurrentMap result = Maps.newConcurrentMap();
        this.files.getOrDefault(languageCode, Collections.emptyList()).forEach(file -> {
            try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
                JsonUtil.loadLanguageMapFromJson(inputStream, result::put);
                MagicLib.getLogger().debug("Loaded language file {}.", file);
            }
            catch (Exception e) {
                MagicLib.getLogger().error("Failed to load language file {}.", file, (Object)e);
            }
        });
        return result;
    }

    @Generated
    private FileLanguageProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static FileLanguageProvider getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    FileLanguageProvider actualValue = new FileLanguageProvider();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (FileLanguageProvider)($value == instance ? null : $value);
    }

    @ApiStatus.Internal
    public static class LanguageFileVisitor
    implements FileVisitor<Path> {
        private final Path basePath;
        private final Map<String, List<Path>> files;
        private final boolean prefix;

        @Override
        @NotNull
        public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
            String name = (this.prefix ? "" : "assets/") + this.basePath.relativize(file).toString().replace("\\", "/");
            Matcher matcher = LanguageProvider.LANGUAGE_PATH_PATTERN.matcher(name);
            if (!matcher.find()) {
                return FileVisitResult.CONTINUE;
            }
            this.files.computeIfAbsent(matcher.group(2), key -> Lists.newArrayList()).add(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult visitFileFailed(Path file, @NotNull IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        @NotNull
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        @Generated
        public LanguageFileVisitor(Path basePath, Map<String, List<Path>> files, boolean prefix) {
            this.basePath = basePath;
            this.files = files;
            this.prefix = prefix;
        }
    }
}

