/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.render.context;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.gui.GuiComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.api.render.context.GuiRenderContext;
import top.hendrixshen.magiclib.api.render.context.LevelRenderContext;
import top.hendrixshen.magiclib.api.render.matrix.MatrixStack;
import top.hendrixshen.magiclib.impl.render.context.GuiRenderContextImpl;
import top.hendrixshen.magiclib.impl.render.context.LevelRenderContextImpl;
import top.hendrixshen.magiclib.impl.render.context.RenderContextImpl;
import top.hendrixshen.magiclib.impl.render.matrix.MinecraftPoseStack;

public interface RenderContext {
    public static LevelRenderContext level(@NotNull PoseStack poseStack) {
        return new LevelRenderContextImpl(new MinecraftPoseStack(poseStack));
    }

    public static GuiRenderContext gui(@NotNull PoseStack poseStack) {
        return new GuiRenderContextImpl(new MinecraftPoseStack(poseStack));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static RenderContext of(@NotNull PoseStack poseStack) {
        return new RenderContextImpl(new MinecraftPoseStack(poseStack));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static LevelRenderContextImpl createWorldRenderContext(@NotNull PoseStack matrixStack) {
        return new LevelRenderContextImpl(new MinecraftPoseStack(matrixStack));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public GuiComponent getGuiComponent();

    public MatrixStack getMatrixStack();

    public void pushMatrix();

    public void popMatrix();

    public void translate(double var1, double var3, double var5);

    public void scale(double var1, double var3, double var5);

    public void mulPoseMatrix(Matrix4f var1);
}

