/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.gui.GuiBase;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.api.malilib.annotation.Config;
import top.hendrixshen.magiclib.api.malilib.annotation.Statistic;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigManager;
import top.hendrixshen.magiclib.api.malilib.config.option.MagicIConfigBase;
import top.hendrixshen.magiclib.game.malilib.Configs;
import top.hendrixshen.magiclib.impl.dependency.DependenciesContainer;
import top.hendrixshen.magiclib.impl.dependency.DependencyCheckResult;
import top.hendrixshen.magiclib.impl.malilib.config.comment.MarkProcessor;
import top.hendrixshen.magiclib.impl.malilib.config.comment.TagProcessor;
import top.hendrixshen.magiclib.impl.malilib.config.statistic.ConfigStatistic;
import top.hendrixshen.magiclib.util.DependencyUtil;
import top.hendrixshen.magiclib.util.collect.InfoNode;

public class ConfigContainer {
    private final Config configAnnotation;
    @Nullable
    private final Statistic statisticAnnotation;
    @Nullable
    private final MagicConfigManager configManager;
    private final MagicIConfigBase config;
    private final List<DependenciesContainer<ConfigContainer>> dependencies;
    private final ConfigStatistic statistic;
    @Nullable
    private Function<String, String> commentModifier = null;
    private boolean appendFooterFlag = true;

    @NotNull
    public static ConfigContainer createIsolated(Field field) {
        return ConfigContainer.create(field, null);
    }

    @NotNull
    public static ConfigContainer createRegulated(Field field, MagicConfigManager configManager) {
        return ConfigContainer.create(field, configManager);
    }

    @NotNull
    private static ConfigContainer create(Field field, MagicConfigManager configManager) {
        return new ConfigContainer(ConfigContainer.assertFieldValidAnnotation(field), (MagicIConfigBase)ConfigContainer.assertFieldObjectValid(field).get(null), configManager);
    }

    public static boolean isValidField(@NotNull Field field) {
        return ConfigContainer.isValidFieldAnnotation(field) && ConfigContainer.isValidFieldObject(field);
    }

    public static boolean isValidFieldAnnotation(@NotNull Field field) {
        return field.isAnnotationPresent(Config.class);
    }

    public static boolean isValidFieldObject(Field field) {
        try {
            return field.get(null) instanceof MagicIConfigBase;
        }
        catch (IllegalAccessException | NullPointerException e) {
            return false;
        }
    }

    private static Field assertFieldValid(Field field) {
        return ConfigContainer.assertFieldObjectValid(ConfigContainer.assertFieldValidAnnotation(field));
    }

    private static Field assertFieldValidAnnotation(Field field) {
        if (!ConfigContainer.isValidFieldAnnotation(field)) {
            throw new IllegalArgumentException("Field " + String.valueOf(field) + " is not annotated with @Config!");
        }
        return field;
    }

    private static Field assertFieldObjectValid(Field field) {
        if (!ConfigContainer.isValidFieldObject(field)) {
            throw new IllegalArgumentException("Field " + String.valueOf(field) + " is not a valid MagicConfig field!");
        }
        return field;
    }

    @Deprecated
    public ConfigContainer(@NotNull Config configAnnotation, @NotNull Field field, MagicIConfigBase config) {
        this(field, config, null);
    }

    private ConfigContainer(@NotNull Field field, MagicIConfigBase config, @Nullable MagicConfigManager configManager) {
        assert (ConfigContainer.isValidFieldAnnotation(field));
        this.configAnnotation = field.getAnnotation(Config.class);
        this.config = config;
        this.statisticAnnotation = field.getAnnotation(Statistic.class);
        this.statistic = new ConfigStatistic();
        this.dependencies = DependencyUtil.parseDependencies(field, this);
        this.configManager = configManager;
    }

    public String getCategory() {
        return this.configAnnotation.category();
    }

    public String getName() {
        return this.config.getName();
    }

    public ImmutableList<DependenciesContainer<ConfigContainer>> getDependencies() {
        return ImmutableList.copyOf(this.dependencies);
    }

    public boolean isDebugOnly() {
        return this.configAnnotation.debugOnly();
    }

    public boolean isDevOnly() {
        return this.configAnnotation.devOnly();
    }

    public boolean isSatisfied() {
        return this.dependencies.isEmpty() || this.dependencies.stream().anyMatch(DependenciesContainer::isSatisfied);
    }

    public boolean shouldStatisticHotkey() {
        if (this.statisticAnnotation == null) {
            return true;
        }
        return this.statisticAnnotation.hotkey();
    }

    public boolean shouldStatisticValueChange() {
        if (this.statisticAnnotation == null) {
            return true;
        }
        return this.statisticAnnotation.valueChanged();
    }

    public void setCommentModifier(@Nullable Function<String, String> commentModifier) {
        this.commentModifier = commentModifier;
    }

    public String modifyComment(String comment) {
        if (this.commentModifier != null) {
            comment = this.commentModifier.apply((String)comment);
        }
        if (this.appendFooterFlag) {
            if (!this.dependencies.stream().allMatch(DependenciesContainer::isSatisfied)) {
                InfoNode rootNode = new InfoNode(null, GuiBase.TXT_GRAY + I18n.tr("magiclib.config.gui.dependencies_footer"));
                ConfigContainer.generateDependencyCheckMessage(this.dependencies, rootNode);
                comment = (String)comment + "\n" + rootNode.toString().replaceAll("\t", " ");
            }
            List<String> lines = this.statistic.getDisplayLines();
            if (Configs.debug.getBooleanValue()) {
                comment = (String)comment + "\n" + GuiBase.TXT_GRAY + I18n.tr("magiclib.config.gui.statistic.title") + GuiBase.TXT_RST;
                comment = (String)comment + "\n" + Joiner.on((char)'\n').join(lines.stream().map(line -> GuiBase.TXT_DARK_GRAY + " " + GuiBase.TXT_GRAY + line + GuiBase.TXT_RST).toArray());
            }
        }
        comment = TagProcessor.processReferences(this, (String)comment);
        comment = MarkProcessor.processMarks((String)comment);
        return comment;
    }

    private static void generateDependencyCheckMessage(@NotNull List<DependenciesContainer<ConfigContainer>> dependencies, InfoNode rootNode) {
        boolean first = true;
        boolean composite = false;
        InfoNode compositeNode = new InfoNode(null, GuiBase.TXT_GRAY + I18n.tr("magiclib.dependency.label.composite") + GuiBase.TXT_RST);
        for (DependenciesContainer<ConfigContainer> dependenciesContainer : dependencies) {
            List<DependencyCheckResult> conflict = dependenciesContainer.checkConflict();
            List<DependencyCheckResult> require = dependenciesContainer.checkRequire();
            InfoNode orNode = null;
            if (first) {
                first = false;
            } else if (!conflict.isEmpty() || !require.isEmpty()) {
                if (!composite) {
                    for (InfoNode child : rootNode.getChildren()) {
                        child.moveTo(compositeNode);
                    }
                    compositeNode.moveTo(rootNode);
                    composite = true;
                }
                orNode = new InfoNode(rootNode, GuiBase.TXT_GRAY + I18n.tr("magiclib.dependency.label.or") + GuiBase.TXT_RST);
            }
            if (!conflict.isEmpty()) {
                InfoNode conflictNode = new InfoNode(orNode == null ? rootNode : orNode, GuiBase.TXT_GRAY + I18n.tr("magiclib.dependency.label.conflict"));
                for (DependencyCheckResult result : conflict) {
                    new InfoNode(conflictNode, (result.isSuccess() ? GuiBase.TXT_GREEN : GuiBase.TXT_RED) + result.getReason());
                }
            }
            if (require.isEmpty()) continue;
            InfoNode requireNode = new InfoNode(orNode == null ? rootNode : orNode, GuiBase.TXT_GRAY + I18n.tr("magiclib.dependency.label.require"));
            for (DependencyCheckResult result : require) {
                new InfoNode(requireNode, (result.isSuccess() ? GuiBase.TXT_GREEN : GuiBase.TXT_RED) + result.getReason());
            }
        }
    }

    @Nullable
    @Generated
    public MagicConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public MagicIConfigBase getConfig() {
        return this.config;
    }

    @Generated
    public ConfigStatistic getStatistic() {
        return this.statistic;
    }

    @Generated
    public void setAppendFooterFlag(boolean appendFooterFlag) {
        this.appendFooterFlag = appendFooterFlag;
    }

    @Generated
    public boolean isAppendFooterFlag() {
        return this.appendFooterFlag;
    }
}

