/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.network.packet;

import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.util.Map;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.network.packet.ClientboundPacketHandler;
import top.hendrixshen.magiclib.api.network.packet.PacketCodec;
import top.hendrixshen.magiclib.api.network.packet.PacketType;
import top.hendrixshen.magiclib.api.network.packet.ServerboundPacketHandler;
import top.hendrixshen.magiclib.api.platform.DistType;
import top.hendrixshen.magiclib.impl.network.packet.MagicCustomPayload;
import top.hendrixshen.magiclib.impl.network.packet.RegistryEntry;

public class MagicPacketRegistry<Handler, Packet> {
    public static final MagicPacketRegistry<ServerboundPacketHandler<?>, ServerboundCustomPayloadPacket> SERVERBOUND_GAME = new MagicPacketRegistry(Direction.SERVERBOUND);
    public static final MagicPacketRegistry<ClientboundPacketHandler<?>, ClientboundCustomPayloadPacket> CLIENTBOUND_GAME = new MagicPacketRegistry(Direction.CLIENTBOUND);
    private final Direction direction;
    private final Map<PacketType<?>, RegistryEntry<Handler, ?>> registry = Maps.newHashMap();

    public <P> void register(PacketType<P> type, PacketCodec<P> codec, Handler handler) {
        if (this.registry.containsKey(type)) {
            throw new IllegalArgumentException(String.format("Duplicate packet type: %s", type));
        }
        this.registry.put(type, new RegistryEntry<Handler, P>(handler, codec));
    }

    public <P> void unregister(PacketType<P> type) {
        this.registry.remove(type);
    }

    public <P> RegistryEntry<Handler, P> getEntry(PacketType<P> type) {
        return this.registry.get(type);
    }

    public <P> Packet createPacket(PacketType<P> type, P packet) {
        RegistryEntry<Handler, P> entry = this.getEntry(type);
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Unknown packet id: %s", type));
        }
        PacketCodec<P> codec = entry.getCodec();
        MagicCustomPayload<P> mcp = new MagicCustomPayload<P>(type, codec, packet);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        mcp.write(buf);
        if (this.direction == Direction.SERVERBOUND) {
            DistType distType = MagicLib.getInstance().getCurrentPlatform().getCurrentDistType();
            if (distType != DistType.CLIENT) {
                throw new RuntimeException("Cannot send Serverbound packet in non-client, current env: " + String.valueOf((Object)distType));
            }
            return (Packet)new ServerboundCustomPayloadPacket(type.getIdentifier(), buf);
        }
        return (Packet)new ClientboundCustomPayloadPacket(type.getIdentifier(), buf);
    }

    @Generated
    public MagicPacketRegistry(Direction direction) {
        this.direction = direction;
    }

    @Generated
    public Map<PacketType<?>, RegistryEntry<Handler, ?>> getRegistry() {
        return this.registry;
    }

    private static enum Direction {
        SERVERBOUND,
        CLIENTBOUND;

    }
}

