/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigManager;
import top.hendrixshen.magiclib.api.malilib.config.option.MagicIConfigBase;
import top.hendrixshen.magiclib.impl.malilib.config.ConfigContainer;
import top.hendrixshen.magiclib.impl.malilib.config.MagicConfigManagerImpl;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public final class GlobalConfigManager {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Map<String, MagicConfigManager> managers = Maps.newHashMap();
    private final List<ConfigContainer> CONTAINERS = Lists.newArrayList();
    private final Map<MagicIConfigBase, ConfigContainer> CONFIG_TO_CONTAINER = Maps.newLinkedHashMap();

    public static void registerConfigManager(@NotNull MagicConfigManager configManager) {
        if (GlobalConfigManager.getInstance().managers.containsKey(configManager.getIdentifier())) {
            throw new IllegalArgumentException("Duplicate config manager: " + configManager.getIdentifier());
        }
        GlobalConfigManager.getInstance().managers.put(configManager.getIdentifier(), configManager);
    }

    @NotNull
    public static MagicConfigManager getConfigManager(String identifier) {
        MagicConfigManager configManager = GlobalConfigManager.getInstance().managers.get(identifier);
        if (configManager == null) {
            configManager = new MagicConfigManagerImpl(identifier);
            GlobalConfigManager.getInstance().managers.put(identifier, configManager);
            InputEventHandler.getKeybindManager().registerKeybindProvider((IKeybindProvider)((MagicConfigManagerImpl)configManager));
        }
        return configManager;
    }

    void registerConfigContainer(ConfigContainer configContainer) {
        this.CONTAINERS.add(configContainer);
        this.CONFIG_TO_CONTAINER.put(configContainer.getConfig(), configContainer);
    }

    @NotNull
    public Collection<ConfigContainer> getAllContainers() {
        return Lists.newArrayList(this.CONTAINERS);
    }

    @NotNull
    public ValueContainer<ConfigContainer> getContainerByConfig(MagicIConfigBase config) {
        return ValueContainer.ofNullable(this.CONFIG_TO_CONTAINER.getOrDefault(config, null));
    }

    public boolean hasConfig(MagicIConfigBase config) {
        return this.getContainerByConfig(config).isPresent();
    }

    @Generated
    private GlobalConfigManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static GlobalConfigManager getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    GlobalConfigManager actualValue = new GlobalConfigManager();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (GlobalConfigManager)($value == instance ? null : $value);
    }
}

