/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.i18n;

import top.hendrixshen.magiclib.impl.i18n.MagicLanguageManager;

public class I18n {
    public static final String DEFAULT_CODE = "en_us";

    public static String tr(String key) {
        return MagicLanguageManager.getInstance().get(key);
    }

    public static String tr(String key, Object ... objects) {
        return MagicLanguageManager.getInstance().get(key, objects);
    }

    public static String trByCode(String code, String key) {
        return MagicLanguageManager.getInstance().getByCode(code, key);
    }

    public static String trByCode(String code, String key, Object ... objects) {
        return MagicLanguageManager.getInstance().getByCode(code, key, objects);
    }

    public static String trInCode(String code, String key) {
        return MagicLanguageManager.getInstance().getInCode(code, key);
    }

    public static String trInCode(String code, String key, Object ... objects) {
        return MagicLanguageManager.getInstance().getInCode(code, key, objects);
    }

    public static boolean exists(String key) {
        return MagicLanguageManager.getInstance().exists(key);
    }

    public static boolean exists(String code, String key) {
        return MagicLanguageManager.getInstance().exists(code, key);
    }

    public static boolean existsIn(String code, String key) {
        return MagicLanguageManager.getInstance().existsIn(code, key);
    }

    public static String translateOrFallback(String key, String fallback) {
        String translated = I18n.tr(key);
        return translated.equals(key) ? fallback : translated;
    }

    public static String translateOrFallback(String key, String fallback, Object ... objects) {
        String translated = I18n.tr(key, objects);
        return translated.equals(key) ? fallback : translated;
    }

    public static String translateByCodeOrFallback(String code, String key, String fallback) {
        String translated = I18n.trByCode(code, key);
        return translated.equals(key) ? fallback : translated;
    }

    public static String translateByCodeOrFallback(String code, String key, String fallback, Object ... object) {
        String translated = I18n.trByCode(code, key, object);
        return translated.equals(key) ? fallback : translated;
    }

    public static String translateInCodeOrFallback(String code, String key, String fallback) {
        String translated = I18n.trInCode(code, key);
        return translated.equals(key) ? fallback : translated;
    }

    public static String translateInCodeOrFallback(String code, String key, String fallback, Object ... object) {
        String translated = I18n.trInCode(code, key, object);
        return translated.equals(key) ? fallback : translated;
    }

    public static String getCurrentLanguageCode() {
        return MagicLanguageManager.getInstance().getCurrentCode();
    }
}

