/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.dependency;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.util.Annotations;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.dependency.DependencyType;
import top.hendrixshen.magiclib.api.dependency.annotation.Dependency;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.api.platform.DistType;
import top.hendrixshen.magiclib.api.platform.Platform;
import top.hendrixshen.magiclib.api.platform.PlatformType;
import top.hendrixshen.magiclib.impl.dependency.DependencyCheckResult;
import top.hendrixshen.magiclib.util.VersionUtil;
import top.hendrixshen.magiclib.util.collect.SimplePredicate;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public class DependencyContainer<T> {
    private final String value;
    private final DependencyType dependencyType;
    private final DistType distType;
    private final PlatformType platformType;
    private final List<String> versionPredicates;
    private final SimplePredicate<T> predicate;
    private final boolean optional;
    private final T obj;

    private DependencyContainer(String value, DependencyType dependencyType, DistType distType, PlatformType platformType, List<String> versionPredicates, SimplePredicate<T> predicate, boolean optional, T obj) {
        this.value = value;
        this.dependencyType = dependencyType;
        this.distType = distType;
        this.platformType = platformType;
        this.versionPredicates = versionPredicates;
        this.predicate = predicate;
        this.optional = optional;
        this.obj = obj;
    }

    @NotNull
    public static <T> DependencyContainer<T> of(@NotNull Dependency dependency, T obj) {
        PlatformType platformType;
        SimplePredicate predicate = null;
        if (dependency.dependencyType() == DependencyType.PREDICATE) {
            try {
                Class<?> clazz = Class.forName(dependency.predicate().getName());
                if (clazz.isInterface()) {
                    throw new IllegalStateException(String.format("Predicate class %s is a interface, excepted implementation class.", clazz.getName()));
                }
                predicate = (SimplePredicate)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to instantiate a Predicate from class %s: %s", dependency.predicate().getName(), e));
            }
        }
        try {
            platformType = dependency.platformType();
        }
        catch (NoSuchMethodError e) {
            platformType = PlatformType.ANY;
        }
        return new DependencyContainer<T>(dependency.value(), dependency.dependencyType(), dependency.distType(), platformType, Lists.newArrayList((Object[])dependency.versionPredicates()), predicate, dependency.optional(), obj);
    }

    @NotNull
    public static <T> DependencyContainer<T> of(AnnotationNode annotationNode, T obj) {
        SimplePredicate predicate = null;
        DependencyType dependencyType = (DependencyType)Annotations.getValue((AnnotationNode)annotationNode, (String)"dependencyType", DependencyType.class, (Enum)DependencyType.MOD_ID);
        if (dependencyType == DependencyType.PREDICATE) {
            Type type = (Type)Annotations.getValue((AnnotationNode)annotationNode, (String)"predicate");
            Objects.requireNonNull(type, "Dependency type is set to PREDICATE mode, which requires the predicate field to be specified!");
            try {
                Class<?> clazz = Class.forName(type.getClassName());
                if (clazz.isInterface()) {
                    throw new IllegalStateException(String.format("Predicate class %s is a interface, excepted implementation class.", clazz.getName()));
                }
                predicate = (SimplePredicate)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to instantiate a Predicate from class %s", type.getClassName()), e);
            }
        }
        return new DependencyContainer<T>((String)Annotations.getValue((AnnotationNode)annotationNode, (String)"value"), dependencyType, (DistType)Annotations.getValue((AnnotationNode)annotationNode, (String)"distType", DistType.class, (Enum)DistType.ANY), (PlatformType)Annotations.getValue((AnnotationNode)annotationNode, (String)"platformType", PlatformType.class, (Enum)PlatformType.ANY), Lists.newArrayList((Iterable)((Iterable)Annotations.getValue((AnnotationNode)annotationNode, (String)"versionPredicates", (Object)Lists.newArrayList()))), predicate, (Boolean)Annotations.getValue((AnnotationNode)annotationNode, (String)"optional", Dependency.class), obj);
    }

    public ValueContainer<DependencyCheckResult> checkAsRequire() {
        Platform platform = MagicLib.getInstance().getCurrentPlatform();
        switch (this.dependencyType) {
            case DIST: {
                DistType currentdistType = platform.getCurrentDistType();
                if (this.distType.matches(currentdistType)) {
                    return ValueContainer.of(new DependencyCheckResult(true, I18n.tr("magiclib.dependency.result.dist.require.success", new Object[]{currentdistType})));
                }
                return ValueContainer.of(new DependencyCheckResult(false, I18n.tr("magiclib.dependency.result.dist.require.fail", new Object[]{this.distType, currentdistType})));
            }
            case MOD_ID: {
                Objects.requireNonNull(this.value, "Dependency type is set to MOD_ID mode and requires mod id as value");
                if (platform.isModExist(this.value)) {
                    String loadedVersion = platform.getModVersion(this.value);
                    if (VersionUtil.isVersionSatisfyPredicates(loadedVersion, this.versionPredicates)) {
                        return ValueContainer.of(new DependencyCheckResult(true, I18n.tr("magiclib.dependency.result.mod_id." + (this.optional ? "optional.success.found" : "require.success"), platform.getModName(this.value), this.value, this.versionPredicates.isEmpty() ? "[*]" : this.versionPredicates)));
                    }
                    return ValueContainer.of(new DependencyCheckResult(false, I18n.tr("magiclib.dependency.result.mod_id." + (this.optional ? "optional.fail" : "require.fail.unsatisfied"), platform.getModName(this.value), this.value, this.versionPredicates.isEmpty() ? "[*]" : this.versionPredicates, loadedVersion)));
                }
                return ValueContainer.of(new DependencyCheckResult(this.optional, I18n.tr("magiclib.dependency.result.mod_id." + (this.optional ? "optional.success" : "require.fail") + ".not_found", this.value, this.versionPredicates.isEmpty() ? "[*]" : this.versionPredicates)));
            }
            case PLATFORM: {
                PlatformType currentPlatformType = platform.getPlatformType();
                if (this.platformType.matches(currentPlatformType)) {
                    return ValueContainer.of(new DependencyCheckResult(true, I18n.tr("magiclib.dependency.result.platform.require.success", new Object[]{currentPlatformType})));
                }
                return ValueContainer.of(new DependencyCheckResult(false, I18n.tr("magiclib.dependency.result.platform.require.fail", new Object[]{this.platformType, currentPlatformType})));
            }
            case PREDICATE: {
                if (this.predicate == null) {
                    return ValueContainer.of(new DependencyCheckResult(true, I18n.tr("magiclib.dependency.result.predicate.target_obj_not_exist")));
                }
                boolean testResult = this.predicate.test(this.obj);
                return ValueContainer.of(new DependencyCheckResult(testResult, I18n.tr("magiclib.dependency.result.predicate.test_result", this.predicate.getClass().getName(), testResult)));
            }
        }
        return ValueContainer.empty();
    }

    public ValueContainer<DependencyCheckResult> checkAsConflict() {
        Platform platform = MagicLib.getInstance().getCurrentPlatform();
        switch (this.dependencyType) {
            case DIST: {
                DistType currentdistType = platform.getCurrentDistType();
                if (this.distType.matches(currentdistType)) {
                    return ValueContainer.of(new DependencyCheckResult(false, I18n.tr("magiclib.dependency.result.dist.conflict.fail", new Object[]{this.distType})));
                }
                return ValueContainer.of(new DependencyCheckResult(true, I18n.tr("magiclib.dependency.result.dist.conflict.success", new Object[]{this.distType})));
            }
            case MOD_ID: {
                Objects.requireNonNull(this.value, "Dependency type is set to MOD_ID mode and requires mod id as value");
                if (platform.isModExist(this.value)) {
                    String loadedVersion = platform.getModVersion(this.value);
                    if (VersionUtil.isVersionSatisfyPredicates(loadedVersion, this.versionPredicates)) {
                        return ValueContainer.of(new DependencyCheckResult(false, I18n.tr("magiclib.dependency.result.mod_id.conflict.fail", platform.getModName(this.value), this.value, loadedVersion, this.versionPredicates.isEmpty() ? "[*]" : this.versionPredicates)));
                    }
                    return ValueContainer.of(new DependencyCheckResult(true, I18n.tr("magiclib.dependency.result.mod_id.conflict.success.unsatisfied", platform.getModName(this.value), this.value, loadedVersion, this.versionPredicates.isEmpty() ? "[*]" : this.versionPredicates)));
                }
                return ValueContainer.of(new DependencyCheckResult(true, I18n.tr("magiclib.dependency.result.mod_id.conflict.success.not_found", this.value)));
            }
            case PLATFORM: {
                PlatformType currentPlatformType = platform.getPlatformType();
                if (this.platformType.matches(currentPlatformType)) {
                    return ValueContainer.of(new DependencyCheckResult(false, I18n.tr("magiclib.dependency.result.platform.conflict.fail", new Object[]{this.platformType})));
                }
                return ValueContainer.of(new DependencyCheckResult(true, I18n.tr("magiclib.dependency.result.platform.conflict.success", new Object[]{this.platformType})));
            }
            case PREDICATE: {
                if (this.predicate == null) {
                    return ValueContainer.of(new DependencyCheckResult(false, I18n.tr("magiclib.dependency.result.predicate.target_obj_not_exist")));
                }
                boolean testResult = this.predicate.test(this.obj);
                return ValueContainer.of(new DependencyCheckResult(!testResult, I18n.tr("magiclib.dependency.result.predicate.test_result", this.predicate.getClass().getName(), testResult)));
            }
        }
        return ValueContainer.empty();
    }

    public boolean isSatisfied(@NotNull DependencyStyle dependencyStyle) {
        ValueContainer result = (ValueContainer)dependencyStyle.function.apply(this);
        return result.isEmpty() || ((DependencyCheckResult)result.get()).isSuccess();
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public DependencyType getDependencyType() {
        return this.dependencyType;
    }

    @Generated
    public DistType getDistType() {
        return this.distType;
    }

    @Generated
    public PlatformType getPlatformType() {
        return this.platformType;
    }

    @Generated
    public List<String> getVersionPredicates() {
        return this.versionPredicates;
    }

    @Generated
    public SimplePredicate<T> getPredicate() {
        return this.predicate;
    }

    @Generated
    public boolean isOptional() {
        return this.optional;
    }

    @Generated
    public T getObj() {
        return this.obj;
    }

    public static enum DependencyStyle {
        CONFLICT(DependencyContainer::checkAsConflict),
        REQUIRE(DependencyContainer::checkAsRequire);

        private final Function<DependencyContainer<?>, ValueContainer<DependencyCheckResult>> function;

        @Generated
        private DependencyStyle(Function<DependencyContainer<?>, ValueContainer<DependencyCheckResult>> function) {
            this.function = function;
        }
    }
}

