/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigManager;
import top.hendrixshen.magiclib.impl.malilib.config.ConfigContainer;
import top.hendrixshen.magiclib.impl.malilib.config.statistic.ConfigStatisticSaver;
import top.hendrixshen.magiclib.util.FileUtil;
import top.hendrixshen.magiclib.util.serializable.JsonSaveAble;

public class MagicConfigHandler
implements IConfigHandler {
    private final MagicConfigManager configManager;
    private final String identifier;
    private final File configFile;
    private JsonObject loadedJson = new JsonObject();
    private final Map<String, JsonSaveAble> internalDataSavers = Maps.newHashMap();
    private final Map<String, JsonSaveAble> externalDataSavers = Maps.newHashMap();
    private final GlobalConfig globalConfig = new GlobalConfig();
    @Nullable
    private Consumer<MagicConfigHandler> preDeserializeCallback;
    @Nullable
    private Consumer<MagicConfigHandler> postDeserializeCallback;
    @Nullable
    private Consumer<MagicConfigHandler> preSerializeCallback;
    @Nullable
    private Consumer<MagicConfigHandler> postSerializeCallback;

    public MagicConfigHandler(@NotNull MagicConfigManager configManager, int configVersion) {
        this.identifier = configManager.getIdentifier();
        this.configFile = FileUtil.getConfigFile(this.identifier);
        this.configManager = configManager;
        this.internalDataSavers.put("global", this.globalConfig);
        this.internalDataSavers.put("config_gui", this.configManager.getGuiSetting());
        this.internalDataSavers.put("configStatistic", new ConfigStatisticSaver(this.configManager));
    }

    public boolean registerExternalData(String namespace, JsonSaveAble data) {
        if (this.externalDataSavers.containsKey(namespace)) {
            return false;
        }
        this.externalDataSavers.put(namespace, data);
        return true;
    }

    public boolean unregisterExternalData(String namespace) {
        if (!this.externalDataSavers.containsKey(namespace)) {
            return false;
        }
        this.externalDataSavers.remove(namespace);
        return true;
    }

    public void loadConfig(JsonObject root) {
        for (String category2 : this.configManager.getCategories().stream().filter(category -> !category.equals("all")).collect(Collectors.toList())) {
            List configs = this.configManager.getContainers(category2).stream().map(ConfigContainer::getConfig).collect(Collectors.toList());
            ConfigUtils.readConfigBase((JsonObject)root, (String)category2, configs);
        }
    }

    public void saveConfig(JsonObject root) {
        for (String category2 : this.configManager.getCategories().stream().filter(category -> !category.equals("all")).collect(Collectors.toList())) {
            List configs = this.configManager.getContainers(category2).stream().map(ConfigContainer::getConfig).collect(Collectors.toList());
            ConfigUtils.writeConfigBase((JsonObject)root, (String)category2, configs);
        }
    }

    public final void loadFromJson(@NotNull JsonObject root) {
        this.loadedJson = root.deepCopy();
        if (this.preDeserializeCallback != null) {
            this.preDeserializeCallback.accept(this);
        }
        this.loadConfig(root);
        this.loadInternal(root);
        this.loadExternal(root);
        if (this.postDeserializeCallback != null) {
            this.postDeserializeCallback.accept(this);
        }
        this.configManager.onConfigLoaded();
    }

    public final void saveToJson() {
        if (this.preSerializeCallback != null) {
            this.preSerializeCallback.accept(this);
        }
        this.saveConfig(this.loadedJson);
        this.saveInternal(this.loadedJson);
        this.saveExternal(this.loadedJson);
        if (this.postSerializeCallback != null) {
            this.postSerializeCallback.accept(this);
        }
    }

    private void loadExternal(JsonObject jsonObject) {
        this.loadInjected(jsonObject, "external", this.externalDataSavers);
    }

    private void saveExternal(JsonObject jsonObject) {
        this.saveInjected(jsonObject, "external", this.externalDataSavers);
    }

    private void loadInternal(JsonObject jsonObject) {
        this.loadInjected(jsonObject, "internal", this.internalDataSavers);
    }

    private void saveInternal(JsonObject jsonObject) {
        this.saveInjected(jsonObject, "internal", this.internalDataSavers);
    }

    private void loadInjected(JsonObject jsonObject, String namespace, Map<String, JsonSaveAble> mapping) {
        JsonObject injected = JsonUtils.getNestedObject((JsonObject)jsonObject, (String)namespace, (boolean)false);
        if (injected != null) {
            mapping.forEach((name, jsonSaveAble) -> {
                JsonObject object = JsonUtils.getNestedObject((JsonObject)injected, (String)name, (boolean)false);
                if (object != null) {
                    jsonSaveAble.loadFromJsonSafe(object);
                }
            });
        }
    }

    private void saveInjected(JsonObject jsonObject, String namespace, @NotNull Map<String, JsonSaveAble> mapping) {
        JsonObject injected = JsonUtils.getNestedObject((JsonObject)jsonObject, (String)namespace, (boolean)true);
        assert (injected != null);
        mapping.forEach((name, jsonSaveAble) -> injected.add(name, (JsonElement)jsonSaveAble.dumpToJson()));
    }

    public final void load() {
        JsonElement element;
        JsonObject root = null;
        if (this.configFile.exists() && this.configFile.isFile() && this.configFile.canRead() && (element = JsonUtils.parseJsonFile((File)this.configFile)) != null && element.isJsonObject()) {
            root = element.getAsJsonObject();
        }
        if (root != null) {
            this.loadFromJson(root);
        }
    }

    public final void save() {
        this.saveToJson();
        JsonUtils.writeJsonToFile((JsonObject)this.loadedJson, (File)this.configFile);
    }

    @Generated
    public MagicConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    @Generated
    public void setPreDeserializeCallback(@Nullable Consumer<MagicConfigHandler> preDeserializeCallback) {
        this.preDeserializeCallback = preDeserializeCallback;
    }

    @Generated
    public void setPostDeserializeCallback(@Nullable Consumer<MagicConfigHandler> postDeserializeCallback) {
        this.postDeserializeCallback = postDeserializeCallback;
    }

    @Generated
    public void setPreSerializeCallback(@Nullable Consumer<MagicConfigHandler> preSerializeCallback) {
        this.preSerializeCallback = preSerializeCallback;
    }

    @Generated
    public void setPostSerializeCallback(@Nullable Consumer<MagicConfigHandler> postSerializeCallback) {
        this.postSerializeCallback = postSerializeCallback;
    }

    private static class GlobalConfig
    implements JsonSaveAble {
        private int configVersion = 0;

        private GlobalConfig() {
        }

        @Override
        public void dumpToJson(@NotNull JsonObject jsonObject) {
            jsonObject.addProperty("config_version", (Number)this.configVersion);
        }

        @Override
        public void loadFromJson(@NotNull JsonObject jsonObject) {
            this.configVersion = jsonObject.get("config_version").getAsInt();
        }
    }
}

