/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.adapter;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class RoomWithBlocks<ROOM, POS, BLOCK> {
    public final ROOM room;
    public final ImmutableMap<POS, BLOCK> containedBlocks;

    public RoomWithBlocks(ROOM room, Map<POS, BLOCK> containedBlocks) {
        this(room, containedBlocks.entrySet());
    }

    public RoomWithBlocks(ROOM room, Iterable<Map.Entry<POS, BLOCK>> containedBlocks) {
        this.room = room;
        ImmutableMap.Builder b = ImmutableMap.builder();
        containedBlocks.forEach(v -> b.put(v.getKey(), v.getValue()));
        this.containedBlocks = b.build();
    }

    public String toString() {
        return "RoomRecipeMatch{room=" + this.room + ", containedBlocks=" + this.containedBlocks + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomWithBlocks that = (RoomWithBlocks)o;
        return Objects.equals(this.room, that.room) && Objects.equals(this.containedBlocks, that.containedBlocks);
    }

    public int hashCode() {
        return Objects.hash(this.room, this.containedBlocks);
    }
}

