/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.core.space;

import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.InclusiveSpaces;
import ca.bradj.roomrecipes.rooms.XWall;
import ca.bradj.roomrecipes.rooms.ZWall;
import java.util.Objects;

public class InclusiveSpace {
    private final Position aa;
    private final Position bb;

    InclusiveSpace(Position aa, Position bb) {
        this.aa = new Position(Math.min(aa.x, bb.x), Math.min(aa.z, bb.z));
        this.bb = new Position(Math.max(aa.x, bb.x), Math.max(aa.z, bb.z));
    }

    public static ISBuilder from(int x, int z) {
        return new ISBuilder(x, z);
    }

    public static ISBuilder from(Position northCorner) {
        return new ISBuilder(northCorner.x, northCorner.z);
    }

    public String toString() {
        return "InclusiveSpace{aa=" + this.aa + ", bb=" + this.bb + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InclusiveSpace that = (InclusiveSpace)o;
        return Objects.equals(this.aa, that.aa) && Objects.equals(this.bb, that.bb);
    }

    public int hashCode() {
        return Objects.hash(this.aa, this.bb);
    }

    public Position getCornerA() {
        return this.aa;
    }

    public Position getCornerB() {
        return this.bb;
    }

    public int getNorthZ() {
        return Math.min(this.aa.z, this.bb.z);
    }

    public int getSouthZ() {
        return Math.max(this.aa.z, this.bb.z);
    }

    public ZWall getWestZWall() {
        return new ZWall(new Position(Math.min(this.aa.x, this.bb.x), this.getNorthZ()), new Position(Math.min(this.aa.x, this.bb.x), this.getSouthZ()));
    }

    public ZWall getEastZWall() {
        return new ZWall(new Position(Math.max(this.aa.x, this.bb.x), this.getNorthZ()), new Position(Math.max(this.aa.x, this.bb.x), this.getSouthZ()));
    }

    public XWall getNorthXWall() {
        return new XWall(new Position(this.getWestX(), Math.min(this.aa.z, this.bb.z)), new Position(this.getEastX(), Math.min(this.aa.z, this.bb.z)));
    }

    public int getWestX() {
        return Math.min(this.aa.x, this.bb.x);
    }

    public int getEastX() {
        return Math.max(this.aa.x, this.bb.x);
    }

    public XWall getSouthXWall() {
        return new XWall(new Position(this.getWestX(), Math.max(this.aa.z, this.bb.z)), new Position(this.getEastX(), Math.max(this.aa.z, this.bb.z)));
    }

    public InclusiveSpace chopOff(InclusiveSpace otherSpace) {
        if (!InclusiveSpaces.overlapOnXZPlane(this, otherSpace)) {
            return new InclusiveSpace(this.aa, this.bb);
        }
        int overlapNorthZ = Math.max(this.getNorthZ(), otherSpace.getNorthZ());
        int overlapSouthZ = Math.min(this.getSouthZ(), otherSpace.getSouthZ());
        int overlapWestX = Math.max(this.getWestX(), otherSpace.getWestX());
        int overlapEastX = Math.min(this.getEastX(), otherSpace.getEastX());
        boolean chopNorth = overlapNorthZ == this.getNorthZ();
        boolean chopSouth = overlapSouthZ == this.getSouthZ();
        boolean chopWest = overlapWestX == this.getWestX();
        boolean chopEast = overlapEastX == this.getEastX();
        Position newAA = new Position(chopWest ? overlapEastX : this.getWestX(), chopNorth ? overlapSouthZ : this.getNorthZ());
        Position newBB = new Position(chopEast ? overlapWestX : this.getEastX(), chopSouth ? overlapNorthZ : this.getSouthZ());
        return new InclusiveSpace(newAA, newBB);
    }

    public static class ISBuilder {
        private final int fromX;
        private final int fromZ;

        public ISBuilder(int x, int z) {
            this.fromX = x;
            this.fromZ = z;
        }

        public InclusiveSpace to(int x, int z) {
            return new InclusiveSpace(new Position(this.fromX, this.fromZ), new Position(x, z));
        }

        public InclusiveSpace to(Position corner) {
            return new InclusiveSpace(new Position(this.fromX, this.fromZ), corner);
        }
    }
}

