/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.core.space;

import ca.bradj.roomrecipes.logic.Direction;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Position
implements Comparable<Position> {
    public final int x;
    public final int z;

    public Position(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public String toString() {
        return "Position{x=" + this.x + ", z=" + this.z + "}";
    }

    public Position offset(int x, int z) {
        return new Position(this.x + x, this.z + z);
    }

    public Position WithX(int x) {
        return new Position(x, this.z);
    }

    public Position WithZ(int z) {
        return new Position(this.x, z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position doorPos = (Position)o;
        return this.x == doorPos.x && this.z == doorPos.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public String getUIString() {
        return String.format("[%d, %d]", this.x, this.z);
    }

    public Position relative(Direction dir) {
        return this.relative(dir, 1);
    }

    public Position relative(Direction dir, int amount) {
        switch (dir) {
            case NORTH: {
                return this.offset(0, -amount);
            }
            case EAST: {
                return this.offset(amount, 0);
            }
            case SOUTH: {
                return this.offset(0, amount);
            }
            case WEST: {
                return this.offset(-amount, 0);
            }
        }
        throw new IllegalArgumentException("Invalid direction: " + dir);
    }

    @Override
    public int compareTo(@NotNull Position o) {
        if (this.x != o.x) {
            return Integer.compare(this.x, o.x);
        }
        return Integer.compare(this.z, o.z);
    }
}

