/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.Direction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;

public class Crawl {
    private final Position checkPos;
    private final boolean isDiagonal;
    private final String dirDesc;
    private final Checks checks;
    private final ImmutableList<Position> checkedAlready;
    private Direction heading;
    private int diagonalBuffer = 2;

    public Crawl(Position checkPos, Direction heading, boolean isDiagonal, String dirDesc, Checks checks, ImmutableList<Position> checkedAlready) {
        this.checkPos = checkPos;
        this.isDiagonal = isDiagonal;
        this.heading = heading;
        this.dirDesc = dirDesc;
        this.checks = checks;
        this.checkedAlready = checkedAlready;
    }

    public String toString() {
        return String.format("Checking %s (%s)", this.dirDesc, this.checkPos.getUIString());
    }

    public ImmutableList<Crawl> getNextSteps(List<Position> visitedSink) {
        visitedSink.add(this.checkPos);
        if (this.checks.isWall(this.checkPos)) {
            if (this.isDiagonal && this.diagonalBuffer > 0) {
                return ImmutableList.of((Object)this.consumePause());
            }
            return Crawl.forwardSpread(this.checkPos, this.heading, this.checks, this.getCheckedPositions(), this.isDiagonal ? this.getCheckedPositions() : visitedSink);
        }
        return ImmutableList.of();
    }

    private Crawl consumePause() {
        --this.diagonalBuffer;
        return this;
    }

    public static ImmutableList<Crawl> forwardSpread(Position checkPos, Direction heading, Checks checks, Collection<Position> alreadyChecked, Collection<Position> visitedSink) {
        Crawl rightTurn = Crawl.from(checkPos).inDirection(heading.cw()).build(checks, alreadyChecked);
        Crawl leftTurn = Crawl.from(checkPos).inDirection(heading.ccw()).build(checks, alreadyChecked);
        Crawl straight = Crawl.from(checkPos).inDirection(heading).build(checks, alreadyChecked);
        Crawl rightDiag = Crawl.from(checkPos).inDirection(heading, heading.cw()).build(checks, alreadyChecked);
        Crawl leftDiag = Crawl.from(checkPos).inDirection(heading, heading.ccw()).build(checks, alreadyChecked);
        ImmutableList.Builder b = ImmutableList.builder();
        if (!visitedSink.contains(rightTurn.checkPos)) {
            b.add((Object)rightTurn);
        }
        if (!visitedSink.contains(leftTurn.checkPos)) {
            b.add((Object)leftTurn);
        }
        if (!visitedSink.contains(straight.checkPos)) {
            b.add((Object)straight);
        }
        if (!visitedSink.contains(rightDiag.checkPos)) {
            b.add((Object)rightDiag);
        }
        if (!visitedSink.contains(leftDiag.checkPos)) {
            b.add((Object)leftDiag);
        }
        return b.build();
    }

    public ImmutableSet<Position> getCheckedPositions() {
        return ImmutableSet.builder().addAll(this.checkedAlready).add((Object)this.checkPos).build();
    }

    public boolean isOrigin() {
        boolean isOrigin = this.checks.isOrigin(this.checkPos);
        if (isOrigin && this.isDiagonal && this.diagonalBuffer > 0) {
            this.consumePause();
            return false;
        }
        return isOrigin;
    }

    public int getWidth() {
        return this.checkedAlready.stream().mapToInt(v -> v.x).max().orElse(0) - this.checkedAlready.stream().mapToInt(v -> v.x).min().orElse(0) + 1;
    }

    public int getHeight() {
        return this.checkedAlready.stream().mapToInt(v -> v.z).max().orElse(0) - this.checkedAlready.stream().mapToInt(v -> v.z).min().orElse(0) + 1;
    }

    public static Builder from(Position prevPos) {
        return new Builder(prevPos);
    }

    public static interface Checks {
        public boolean isWall(Position var1);

        public boolean isOrigin(Position var1);
    }

    public static final class Builder {
        private final Position prevPos;
        private Direction dir;
        private Direction dir2;

        public Builder(Position prevPos) {
            this.prevPos = prevPos;
        }

        public Builder inDirection(Direction dir90) {
            this.dir = dir90;
            return this;
        }

        public Builder inDirection(Direction dir1, Direction dir2) {
            this.dir = dir1;
            this.dir2 = dir2;
            return this;
        }

        public Crawl build(Checks doneCondition, Collection<Position> alreadyChecked) {
            Position startPos = this.prevPos.relative(this.dir);
            String dirDesc = this.dir.toString();
            if (this.dir2 != null) {
                startPos = startPos.relative(this.dir2);
                dirDesc = Direction.toString(this.dir, this.dir2);
            }
            return new Crawl(startPos, this.dir, this.dir2 != null, dirDesc, doneCondition, (ImmutableList<Position>)ImmutableList.copyOf(alreadyChecked));
        }
    }
}

