/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.rooms.XWall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class InclusiveSpaces {
    public static InclusiveSpace around(Position pos, int radius) {
        return InclusiveSpace.from(pos.offset(-radius, -radius)).to(pos.offset(radius, radius));
    }

    public static boolean overlapOnXZPlane(InclusiveSpace space1, InclusiveSpace space2) {
        int space1MinX = space1.getWestX();
        int space1MaxX = space1.getEastX();
        int space2MinX = space2.getWestX();
        int space2MaxX = space2.getEastX();
        int space1MinZ = space1.getNorthZ();
        int space1MaxZ = space1.getSouthZ();
        int space2MinZ = space2.getNorthZ();
        int space2MaxZ = space2.getSouthZ();
        boolean overlapX = false;
        if (space1MaxX > space2MinX && space2MaxX > space1MinX) {
            overlapX = true;
        }
        boolean overlapZ = false;
        if (space1MaxZ > space2MinZ && space2MaxZ > space1MinZ) {
            overlapZ = true;
        }
        return overlapX && overlapZ;
    }

    public static double calculateArea(InclusiveSpace space) {
        Position cornerA = space.getCornerA();
        Position cornerB = space.getCornerB();
        int length = Math.abs(cornerA.x - cornerB.x) + 1;
        int width = Math.abs(cornerA.z - cornerB.z) + 1;
        return Math.max(0.0, (double)length * (double)width);
    }

    public static double calculateArea(Collection<? extends InclusiveSpace> spaces) {
        return spaces.stream().mapToDouble(InclusiveSpaces::calculateArea).sum();
    }

    public static Position getRandomEnclosedPosition(InclusiveSpace space, Function<Integer, Integer> randomInt) {
        int minX = space.getWestX() + 1;
        int maxX = space.getEastX();
        int minZ = space.getNorthZ() + 1;
        int maxZ = space.getSouthZ();
        int width = maxX - minX;
        int height = maxZ - minZ;
        return new Position(minX + randomInt.apply(width), minZ + randomInt.apply(height));
    }

    @Deprecated(since="0.0.7", forRemoval=true)
    public static Collection<Position> getAllEnclosedPositions(InclusiveSpace space) {
        int minX = space.getWestX() + 1;
        int maxX = space.getEastX();
        int minZ = space.getNorthZ() + 1;
        int maxZ = space.getSouthZ();
        ImmutableList.Builder b = ImmutableList.builder();
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                b.add((Object)new Position(x, z));
            }
        }
        return b.build();
    }

    public static boolean isCorner(InclusiveSpace sp, Position testPos) {
        XWall nw = sp.getNorthXWall();
        if (nw.westCorner.equals(testPos) || nw.eastCorner.equals(testPos)) {
            return true;
        }
        XWall sw = sp.getSouthXWall();
        return sw.westCorner.equals(testPos) || sw.eastCorner.equals(testPos);
    }

    public static Collection<Position> getPositions(InclusiveSpace space, PositionType type) {
        int minX = space.getWestX();
        int maxX = space.getEastX();
        int minZ = space.getNorthZ();
        int maxZ = space.getSouthZ();
        ImmutableList.Builder b = ImmutableList.builder();
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                boolean isWall;
                boolean bl = isWall = x == minX || x == maxX || z == minZ || z == maxZ;
                if (minX == maxX) {
                    boolean bl2 = isWall = z == minZ || z == maxZ;
                }
                if (minZ == maxZ) {
                    boolean bl3 = isWall = x == minX || x == maxX;
                }
                if (type == PositionType.WALLS_ONLY && isWall) {
                    b.add((Object)new Position(x, z));
                    continue;
                }
                if (type == PositionType.WALLS_AND_INTERIOR) {
                    b.add((Object)new Position(x, z));
                    continue;
                }
                if (type != PositionType.INTERIOR_ONLY || isWall) continue;
                b.add((Object)new Position(x, z));
            }
        }
        return b.build();
    }

    public static Position getMidpoint(InclusiveSpace space) {
        int leftInside = space.getWestX() + 1;
        int rightInside = space.getEastX() - 1;
        int halfWidth = (rightInside - leftInside) / 2;
        int northInside = space.getNorthZ() + 1;
        int southInside = space.getSouthZ() - 1;
        int halfHeight = (southInside - northInside) / 2;
        return new Position(leftInside + halfWidth, northInside + halfHeight);
    }

    public static boolean contains(Iterable<? extends InclusiveSpace> spaces, Position pos) {
        for (InclusiveSpace inclusiveSpace : spaces) {
            if (!InclusiveSpaces.contains(inclusiveSpace, pos)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(InclusiveSpace space, Position pos) {
        if (pos.x < space.getWestX() + 1) {
            return false;
        }
        if (pos.x > space.getEastX()) {
            return false;
        }
        if (pos.z < space.getNorthZ() + 1) {
            return false;
        }
        return pos.z <= space.getSouthZ();
    }

    public static boolean isWhole(InclusiveSpace space, Predicate<Position> isWallO, boolean requireCorners) {
        if (space == null) {
            return false;
        }
        HashMap cache = new HashMap();
        Predicate<Position> isWall = p -> cache.compute(p, (p2, r) -> r != null ? r.booleanValue() : isWallO.test((Position)p2));
        if (!InclusiveSpaces.hasNorthAndSouthWalls(space, isWall, requireCorners)) {
            return false;
        }
        if (!InclusiveSpaces.hasWestAndEastWalls(space, isWall, requireCorners)) {
            return false;
        }
        int x = space.getWestX() + 1;
        while (x < space.getEastX() - 1) {
            int xx;
            if (!InclusiveSpaces.hasZWall(space, arg_0 -> InclusiveSpaces.lambda$isWhole$2(isWall, xx = x++, arg_0), requireCorners)) continue;
            return false;
        }
        int z = space.getNorthZ() + 1;
        while (z < space.getSouthZ() - 1) {
            int zz;
            if (!InclusiveSpaces.hasZWall(space, arg_0 -> InclusiveSpaces.lambda$isWhole$3(isWall, zz = z++, arg_0), requireCorners)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasWestAndEastWalls(InclusiveSpace space, Predicate<Position> isWall, boolean requireCorners) {
        return InclusiveSpaces.hasZWall(space, z -> {
            Position west = new Position(space.getWestX(), (int)z);
            Position east = new Position(space.getEastX(), (int)z);
            return isWall.test(west) && isWall.test(east);
        }, requireCorners);
    }

    private static boolean hasZWall(InclusiveSpace space, Predicate<Integer> test, boolean requireCorners) {
        int top = requireCorners ? space.getNorthZ() : space.getNorthZ() + 1;
        int bot = requireCorners ? space.getSouthZ() : space.getSouthZ() - 1;
        for (int z = top; z < bot; ++z) {
            if (test.test(z)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasXWall(InclusiveSpace space, Predicate<Integer> test, boolean requireCorners) {
        int neg = requireCorners ? space.getWestX() : space.getWestX() + 1;
        int pos = requireCorners ? space.getEastX() : space.getEastX() - 1;
        for (int x = neg; x < pos; ++x) {
            if (test.test(x)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasNorthAndSouthWalls(InclusiveSpace space, Predicate<Position> isWall, boolean requireCorners) {
        return InclusiveSpaces.hasXWall(space, x -> {
            Position north = new Position((int)x, space.getNorthZ());
            Position south = new Position((int)x, space.getSouthZ());
            return isWall.test(north) && isWall.test(south);
        }, requireCorners);
    }

    public static boolean fullyContains(InclusiveSpace inclusiveSpace, InclusiveSpace ss) {
        if (ss.getWestX() < inclusiveSpace.getWestX()) {
            return false;
        }
        if (ss.getNorthZ() < inclusiveSpace.getNorthZ()) {
            return false;
        }
        if (ss.getEastX() > inclusiveSpace.getEastX()) {
            return false;
        }
        return ss.getSouthZ() <= inclusiveSpace.getSouthZ();
    }

    public static ImmutableSet<Position> getWallPositions(InclusiveSpace rect) {
        return InclusiveSpaces.getWallPositions(rect, true);
    }

    public static ImmutableSet<Position> getWallPositions(InclusiveSpace space, boolean includeCorners) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int offset = includeCorners ? 0 : 1;
        for (int x = space.getWestX() + offset; x <= space.getEastX() - offset; ++x) {
            builder.add((Object)new Position(x, space.getNorthZ()));
            builder.add((Object)new Position(x, space.getSouthZ()));
        }
        for (int z = space.getNorthZ() + offset; z <= space.getSouthZ() - offset; ++z) {
            builder.add((Object)new Position(space.getWestX(), z));
            builder.add((Object)new Position(space.getEastX(), z));
        }
        return builder.build();
    }

    public static String getShortString(InclusiveSpace space) {
        return "[ " + space.getCornerA().getUIString() + " -> " + space.getCornerB().getUIString() + " ]";
    }

    public static String getShortString(Collection<InclusiveSpace> spaces) {
        return spaces.stream().map(InclusiveSpaces::getShortString).reduce((a, b) -> a + ", " + b).orElse("[]");
    }

    private static /* synthetic */ boolean lambda$isWhole$3(Predicate isWall, int zz, Integer x) {
        return isWall.test(new Position(x, zz));
    }

    private static /* synthetic */ boolean lambda$isWhole$2(Predicate isWall, int xx, Integer z) {
        return isWall.test(new Position(xx, z));
    }

    public static enum PositionType {
        WALLS_ONLY,
        WALLS_AND_INTERIOR,
        INTERIOR_ONLY;

    }
}

