/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.RoomRecipes;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.InclusiveSpaces;
import ca.bradj.roomrecipes.logic.RoomDetection;
import ca.bradj.roomrecipes.logic.WallWalkingRoomDetection;
import ca.bradj.roomrecipes.logic.interfaces.WallDetector;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelRoomDetector {
    private final Queue<Position> doorsToProcess = new LinkedBlockingQueue<Position>();
    private final ImmutableList<Position> initialDoors;
    private final boolean enableDebugArt;
    private final Consumer<String> flightRecorder;
    private Map<Position, Optional<Room>> processedRooms = new HashMap<Position, Optional<Room>>();
    private final int maxDistanceFromDoor;
    private final TriPredicate<Position, @Nullable Position, @Nullable String[][]> checker;
    private Map<Position, Integer> doorIteration = new HashMap<Position, Integer>();
    private int iteration = 0;
    private int maxIterations;
    private boolean done;
    private final Map<Position, String[][]> debugArt = new HashMap<Position, String[][]>();

    public LevelRoomDetector(Collection<Position> currentDoors, int maxDistanceFromDoor, int maxIterations, WallDetector checker, boolean enableDebugArt, @Nullable Consumer<String> flightRecorder) {
        this.doorsToProcess.addAll(currentDoors);
        this.initialDoors = ImmutableList.copyOf(currentDoors);
        this.maxDistanceFromDoor = maxDistanceFromDoor;
        this.maxIterations = maxIterations;
        HashMap cache = new HashMap();
        this.checker = (p, nextDoor, art) -> cache.compute(p, (p2, r) -> {
            if (r != null) {
                return r;
            }
            boolean b = checker.IsWall((Position)p2);
            if (enableDebugArt && nextDoor != null && art != null) {
                LevelRoomDetector.captureAsArtPixel(p2, nextDoor, art, b, "W", " ", maxDistanceFromDoor);
                LevelRoomDetector.captureSurroundingAsArtPixels(checker::IsWall, p2, nextDoor, art, "w", "_", maxDistanceFromDoor);
            }
            return b;
        });
        this.enableDebugArt = enableDebugArt;
        if (enableDebugArt) {
            currentDoors.forEach(door -> {
                this.debugArt.put((Position)door, new String[maxDistanceFromDoor * 2 + 2][maxDistanceFromDoor * 2 + 2]);
                this.debugArt.get((Object)door)[maxDistanceFromDoor][maxDistanceFromDoor] = "D";
            });
        }
        this.flightRecorder = flightRecorder == null ? s -> {} : flightRecorder;
    }

    public boolean isDone() {
        return this.done;
    }

    public int iterationsUsed() {
        return this.iteration;
    }

    @Nullable
    public ImmutableMap<Position, Optional<Room>> proceed() {
        return this.proceed(p -> Optional.empty());
    }

    @Nullable
    public ImmutableMap<Position, Optional<Room>> proceed(Function<Position, Optional<Room>> existingRooms) {
        ++this.iteration;
        if (this.iteration > this.maxIterations) {
            RoomRecipes.LOGGER.error("Failed to detect rooms after {} iterations", (Object)this.maxIterations);
            return this.giveUp();
        }
        if (this.doorsToProcess.isEmpty()) {
            this.done = true;
            if (this.processedRooms.isEmpty()) {
                return this.giveUp();
            }
            return this.removeOverlaps(this.processedRooms);
        }
        Position nextDoor = this.doorsToProcess.remove();
        Optional<Room> existing = existingRooms.apply(nextDoor);
        if (existing.isPresent() && InclusiveSpaces.isWhole(existing.get().getSpace(), p -> this.checker.test(p, null, null), true)) {
            this.processedRooms.put(nextDoor, existing);
            return null;
        }
        if (this.doorIteration.getOrDefault(nextDoor, 0) > this.maxDistanceFromDoor - 2) {
            return null;
        }
        Optional<Room> roomForDoor = WallWalkingRoomDetection.tryFind(nextDoor, this.doorIteration.getOrDefault(nextDoor, 0), this.flightRecorder, p -> this.checker.test((Object)p, (Object)nextDoor, (Object)this.debugArt.get(nextDoor))).toOptional();
        if (roomForDoor.isEmpty()) {
            this.doorsToProcess.add(nextDoor);
            this.doorIteration.compute(nextDoor, (pos, cur) -> cur == null ? 1 : cur + 1);
            return null;
        }
        this.processedRooms.put(nextDoor, roomForDoor);
        return null;
    }

    private static void captureSurroundingAsArtPixels(Predicate<Position> isWall, Position p, Position nextDoor, String[][] art, String w, String a, int maxDistanceFromDoor) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                Position op = p.offset(i, j);
                boolean b2 = isWall.test(op);
                LevelRoomDetector.captureAsArtPixel(op, nextDoor, art, b2, w, a, maxDistanceFromDoor);
            }
        }
    }

    public static void captureAsArtPixel(Position p, Position nextDoor, String[][] art, boolean isWall, String w, String a, int maxDistanceFromDoor) {
        int zOffset = p.z - nextDoor.z;
        int xOffset = p.x - nextDoor.x;
        int zzz = maxDistanceFromDoor + zOffset;
        int xxx = maxDistanceFromDoor + xOffset;
        if (zzz >= art.length || xxx >= art[0].length || zzz < 0 || xxx < 0) {
            return;
        }
        try {
            String v = art[zzz][xxx];
            if (v == null || art[zzz][xxx].equals("w") || art[zzz][xxx].equals("_")) {
                art[zzz][xxx] = isWall ? w : a;
            }
        }
        catch (Exception e) {
            RoomRecipes.LOGGER.error("Failed to register art pixel for {} around door {}", (Object)p.getUIString(), (Object)nextDoor.getUIString());
            RoomRecipes.LOGGER.error("Exception", (Throwable)e);
        }
    }

    private ImmutableMap<Position, Optional<Room>> removeOverlaps(Map<Position, Optional<Room>> detectedRooms) {
        int attempts = 0;
        int corrections = 1;
        block0: while (corrections > 0 && attempts <= 3) {
            this.flightRecorder.accept(String.format("Running overlap removal. Attempt %d. Corrections: %d", ++attempts, corrections));
            Stream<Optional> onlyPresent = detectedRooms.values().stream().filter(Optional::isPresent);
            ImmutableMap rooms = ImmutableMap.copyOf(onlyPresent.map(Optional::get).map(v -> new AbstractMap.SimpleEntry<Position, Room>(v.doorPos, (Room)v)).toList());
            List<Position> leastUsedDoorPositions = this.getLeastUsedDoorPositionsFirst(rooms.values());
            corrections = 0;
            block1: for (Position p1 : leastUsedDoorPositions) {
                Room r1 = (Room)rooms.get(p1);
                if (corrections > 0) continue block0;
                for (Position p2 : leastUsedDoorPositions) {
                    InclusiveSpace chopped;
                    Room r2 = (Room)rooms.get(p2);
                    if (r1.equals(r2)) continue;
                    Position r1dp = r1.getDoorPos();
                    Position r2dp = r2.getDoorPos();
                    Function<Room, InclusiveSpace> gs = r -> (InclusiveSpace)r.getSpaces().get(0);
                    InclusiveSpace r1Space = gs.apply(r1);
                    InclusiveSpace r2Space = gs.apply(r2);
                    if (r1.getSpaces().equals(r2.getSpaces())) {
                        Optional<Room> alternate = RoomDetection.findRoomForDoor(r2dp, this.maxDistanceFromDoor, Optional.of(r1Space), 0, this::checkWithoutArt).toOptional();
                        if (alternate.isPresent()) {
                            if (rooms.values().stream().anyMatch(v -> ((InclusiveSpace)gs.apply((Room)v)).equals(gs.apply((Room)alternate.get())))) {
                                detectedRooms.put(r2dp, Optional.empty());
                                ++corrections;
                                continue block1;
                            }
                            this.flightRecorder.accept("Using alternate room: " + this.sm(alternate.get()));
                            detectedRooms.put(r2dp, alternate);
                            ++corrections;
                            continue block1;
                        }
                        Optional<Room> alternate2 = RoomDetection.findRoomForDoor(r1dp, this.maxDistanceFromDoor, Optional.of(r2Space), 0, this::checkWithoutArt).toOptional();
                        if (alternate2.isPresent()) {
                            detectedRooms.put(r1dp, alternate2);
                            ++corrections;
                            this.flightRecorder.accept("Using alternate room: " + this.sm(alternate2.get()));
                            continue block1;
                        }
                        detectedRooms.put(r2dp, Optional.empty());
                        ++corrections;
                        continue block1;
                    }
                    if (r2.getSpaces().size() > 1 && r2.getSpaces().contains((Object)r1.getSpace())) {
                        this.flightRecorder.accept("Removing space " + this.sm(r1Space) + " from " + r2dp + " because it has multiple spaces and this space is already in " + r1dp);
                        detectedRooms.put(r2.doorPos, Optional.of(r2.withSpaceRemoved(r1.getSpace())));
                        ++corrections;
                        continue block1;
                    }
                    if (r1.getSpaces().size() > 1 && r1.getSpaces().contains((Object)r2.getSpace())) {
                        this.flightRecorder.accept("Removing space " + this.sm(r2Space) + " from " + r1dp + " because it has multiple spaces and this space is already in " + r2dp);
                        detectedRooms.put(r1.doorPos, Optional.of(r1.withSpaceRemoved(r2.getSpace())));
                        ++corrections;
                        continue block1;
                    }
                    if (!InclusiveSpaces.overlapOnXZPlane(r1Space, r2Space)) continue;
                    this.flightRecorder.accept("Spaces overlap on X/Z plane");
                    double a1 = InclusiveSpaces.calculateArea(r1Space);
                    double a2 = InclusiveSpaces.calculateArea(r2Space);
                    if (a1 > a2) {
                        this.flightRecorder.accept("[B1] Chopping " + this.sm(r2Space) + " off of " + this.sm(r1Space));
                        chopped = r1Space.chopOff(r2Space);
                        if (!InclusiveSpaces.getWallPositions(chopped).contains((Object)r1dp)) {
                            this.flightRecorder.accept("Giving " + this.sm(r2Space) + " to " + r2dp + " instead of " + r1dp);
                            detectedRooms.put(r2dp, Optional.of(r2.withSpace(chopped)));
                            detectedRooms.put(r1dp, Optional.of(r1.withSpace(r2Space)));
                            ++corrections;
                            continue block1;
                        }
                        this.flightRecorder.accept("Giving chopped-off portion to " + r1dp);
                        detectedRooms.put(r1dp, Optional.of(r1.withSpace(chopped)));
                        ++corrections;
                        continue block1;
                    }
                    if (!(a2 > a1)) continue;
                    this.flightRecorder.accept("[B2] Chopping " + this.sm(r1Space) + " off of " + this.sm(r2Space));
                    chopped = r2Space.chopOff(r1Space);
                    if (!InclusiveSpaces.getWallPositions(chopped).contains((Object)r2dp)) {
                        this.flightRecorder.accept("Giving " + this.sm(r1Space) + " to " + r1dp + " instead of " + r2dp);
                        detectedRooms.put(r1dp, Optional.of(r1.withSpace(chopped)));
                        detectedRooms.put(r2dp, Optional.of(r2.withSpace(r1Space)));
                        ++corrections;
                        continue block1;
                    }
                    this.flightRecorder.accept("Giving chopped-off portion to " + r2dp);
                    detectedRooms.put(r2dp, Optional.of(r2.withSpace(chopped)));
                    ++corrections;
                    continue block1;
                }
            }
        }
        return ImmutableMap.copyOf(detectedRooms);
    }

    private List<Position> getLeastUsedDoorPositionsFirst(Collection<Room> values) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (Room value : values) {
            for (InclusiveSpace space : value.getSpaces()) {
                b.addAll(InclusiveSpaces.getWallPositions(space));
            }
        }
        ImmutableList wallPos = b.build();
        HashMap<Position, Integer> m = new HashMap<Position, Integer>();
        for (Room value : values) {
            if (!wallPos.contains((Object)value.doorPos)) continue;
            m.merge(value.doorPos, -1, Integer::sum);
        }
        return (List)m.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
    }

    private String sm(Room room) {
        return "Room{" + room.getDoorPos().getUIString() + ": " + InclusiveSpaces.getShortString(room.getSpaces()) + "}";
    }

    private String sm(InclusiveSpace space) {
        return InclusiveSpaces.getShortString(space);
    }

    private boolean checkWithoutArt(Position p) {
        return this.checker.test((Object)p, null, null);
    }

    private ImmutableMap<Position, Optional<Room>> giveUp() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        this.initialDoors.forEach(v -> b.put(v, Optional.empty()));
        return b.build();
    }

    public ImmutableMap<Position, String> getDebugArt(boolean cropNulls) {
        if (!this.enableDebugArt) {
            RoomRecipes.LOGGER.error("Debug art was not enabled in the room detector constructor");
            return ImmutableMap.of();
        }
        return LevelRoomDetector.doGetDebugArt(this.debugArt, cropNulls);
    }

    @NotNull
    public static ImmutableMap<Position, String> doGetDebugArt(Map<Position, String[][]> debugArt, boolean cropNulls) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        debugArt.forEach((k, v) -> {
            if (cropNulls) {
                v = LevelRoomDetector.findSmallestRectangle(v);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\n");
            for (int i = 0; i < ((String[][])v).length; ++i) {
                sb.append("    {");
                for (int j = 0; j < v[i].length; ++j) {
                    String val = v[i][j];
                    sb.append("\"").append(val == null ? Character.valueOf('?') : val).append("\"");
                    if (j >= v[i].length - 1) continue;
                    sb.append(", ");
                }
                sb.append("}");
                if (i < ((String[][])v).length - 1) {
                    sb.append(",\n");
                    continue;
                }
                sb.append("\n");
            }
            sb.append("}");
            b.put(k, (Object)sb.toString());
        });
        return b.build();
    }

    public static String[][] findSmallestRectangle(String[][] array) {
        int minRow = Integer.MAX_VALUE;
        int maxRow = Integer.MIN_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxCol = Integer.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                if (array[i][j] == null) continue;
                minRow = Math.min(minRow, i);
                maxRow = Math.max(maxRow, i);
                minCol = Math.min(minCol, j);
                maxCol = Math.max(maxCol, j);
            }
        }
        int numRows = maxRow - minRow + 1;
        int numCols = maxCol - minCol + 1;
        String[][] smallestRectangle = new String[numRows][numCols];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                smallestRectangle[i][j] = array[minRow + i][minCol + j];
            }
        }
        return smallestRectangle;
    }

    private record Door(Position doorPos, int spaceIndex) {
    }
}

