/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.Direction;
import ca.bradj.roomrecipes.logic.InclusiveSpaces;
import ca.bradj.roomrecipes.logic.RoomHints;
import ca.bradj.roomrecipes.logic.Search;
import ca.bradj.roomrecipes.logic.Walls;
import ca.bradj.roomrecipes.logic.XWalls;
import ca.bradj.roomrecipes.logic.ZWalls;
import ca.bradj.roomrecipes.logic.interfaces.WallDetector;
import ca.bradj.roomrecipes.rooms.Wall;
import ca.bradj.roomrecipes.rooms.XWall;
import ca.bradj.roomrecipes.rooms.ZWall;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class RoomDetection {
    public static Search<Room> findRoomForDoor(Position doorPos, int maxDistanceFromDoor, int depth, WallDetector wd) {
        return RoomDetection.findRoomForDoor(doorPos, maxDistanceFromDoor, depth, wd, null);
    }

    public static Search<Room> findRoomForDoor(Position doorPos, int maxDistanceFromDoor, int depth, WallDetector wd, Consumer<String> recorder) {
        return RoomDetection.findRoomForDoor(doorPos, maxDistanceFromDoor, new SearchRange(null, null, null, null), Optional.empty(), recorder, WallExclusion.mustHaveAllWalls(), depth + 1, wd);
    }

    public static Search<Room> findRoomForDoor(Position doorPos, int maxDistanceFromDoor, Optional<InclusiveSpace> findAlternativeTo, int depth, WallDetector wd) {
        return RoomDetection.findRoomForDoor(doorPos, maxDistanceFromDoor, new SearchRange(null, null, null, null), findAlternativeTo, WallExclusion.mustHaveAllWalls(), depth + 1, wd);
    }

    public static Search<Room> findRoomForDoorIteration(Position nextDoor, int i, int maxDistanceFromDoor, Consumer<String> flightRecorder, WallDetector checker) {
        return RoomDetection.findRoomForDoorIteration(nextDoor, i, maxDistanceFromDoor, SearchRange.outermost(), Optional.empty(), WallExclusion.mustHaveAllWalls(), 0, flightRecorder, checker, (ImmutableList<InclusiveSpace>)ImmutableList.of());
    }

    public static Search<Room> findRoomForDoorIteration(Position doorPos, int i, int maxDistanceFromDoor, SearchRange range, Optional<InclusiveSpace> findAlternativeTo, WallExclusion exclusion, int depth, Consumer<String> flightRecorder, WallDetector wd, ImmutableList<InclusiveSpace> spacesFoundAlready) {
        Position offset;
        if (!wd.IsWall(doorPos)) {
            return Search.empty();
        }
        RoomDetection.record(flightRecorder, "Searching outward from door position %s [radius %d]", doorPos.getUIString(), i);
        Function<Position, Search> findFromBackWall = wallPos -> RoomDetection.findRoomFromBackWall(doorPos, wallPos, maxDistanceFromDoor, findAlternativeTo, exclusion, depth + 1, s -> RoomDetection.record(flightRecorder, s, new Object[0]), wd, spacesFoundAlready);
        Search foundRoom = Search.empty();
        if (!exclusion.allowOpenEastWall) {
            offset = doorPos.offset(i, 0);
            if (range.maxEastZ == null || offset.x <= range.maxEastZ) {
                RoomDetection.record(flightRecorder, "Assessing valid coordinate for the east back wall at %s", offset.getUIString());
                foundRoom = findFromBackWall.apply(offset);
                if (foundRoom.isPresent()) {
                    return foundRoom;
                }
            }
        }
        if (!exclusion.allowOpenWestWall) {
            offset = doorPos.offset(-i, 0);
            if (range.minWestZ == null || offset.x >= range.minWestZ) {
                RoomDetection.record(flightRecorder, "Assessing valid coordinate for the west back wall at %s", offset.getUIString());
                foundRoom = findFromBackWall.apply(offset);
                if (foundRoom.isPresent()) {
                    return foundRoom;
                }
            }
        }
        offset = doorPos.offset(0, i);
        if (range.maxSouthZ == null || offset.z <= range.maxSouthZ) {
            RoomDetection.record(flightRecorder, "Assessing valid coordinate for the south back wall at %s", offset.getUIString());
            foundRoom = findFromBackWall.apply(offset);
            if (foundRoom.isPresent()) {
                return foundRoom;
            }
        }
        offset = doorPos.offset(0, -i);
        if (range.minNorthZ == null || offset.z >= range.minNorthZ) {
            RoomDetection.record(flightRecorder, "Assessing valid coordinate for the north back wall at %s", offset.getUIString());
            foundRoom = findFromBackWall.apply(offset);
            if (foundRoom.isPresent()) {
                return foundRoom;
            }
        }
        return Search.empty();
    }

    private static void record(Consumer<String> flightRecorder, String s, Object ... uiString) {
        if (flightRecorder == null) {
            return;
        }
        flightRecorder.accept(String.format(s, uiString));
    }

    public static Search<Room> findRoomForDoor(Position doorPos, int maxDistanceFromDoor, SearchRange range, Optional<InclusiveSpace> findAlternativeTo, WallExclusion exclusion, int depth, WallDetector wd) {
        return RoomDetection.findRoomForDoor(doorPos, maxDistanceFromDoor, range, findAlternativeTo, null, exclusion, depth, wd);
    }

    public static Search<Room> findRoomForDoor(Position doorPos, int maxDistanceFromDoor, SearchRange range, Optional<InclusiveSpace> findAlternativeTo, Consumer<String> recorder, WallExclusion exclusion, int depth, WallDetector wd) {
        for (int i = 2; i < maxDistanceFromDoor; ++i) {
            Search<Room> res = RoomDetection.findRoomForDoorIteration(doorPos, i, maxDistanceFromDoor, range, findAlternativeTo, exclusion, depth, recorder, wd, (ImmutableList<InclusiveSpace>)ImmutableList.of());
            if (!res.isPresent()) continue;
            return res;
        }
        return Search.empty();
    }

    private static Search<Room> findRoomFromBackWall(Position doorPos, Position wallPos, int maxDistFromDoor, Optional<InclusiveSpace> findAlt, int depth, Consumer<String> flightRecorder, WallDetector wd, ImmutableList<InclusiveSpace> spacesFoundAlready) {
        return RoomDetection.findRoomFromBackWall(doorPos, wallPos, maxDistFromDoor, findAlt, WallExclusion.mustHaveAllWalls(), depth + 1, flightRecorder, wd, spacesFoundAlready);
    }

    private static Search<Room> findRoomFromBackWall(Position doorPos, Position wallPos, int maxDistFromDoor, Optional<InclusiveSpace> findAlt, WallExclusion exclusion, int depth, Consumer<String> flightRecorder, WallDetector wd, ImmutableList<InclusiveSpace> spacesFoundAlready) {
        if (!wd.IsWall(wallPos)) {
            flightRecorder.accept("Was air at " + wallPos.getUIString());
            return Search.empty();
        }
        flightRecorder.accept("Was wall block at " + wallPos.getUIString());
        Search<Room> room = RoomDetection.findRoomBetween(doorPos, wallPos, maxDistFromDoor, exclusion, depth + 1, flightRecorder, wd, spacesFoundAlready);
        if (room.isEmpty()) {
            flightRecorder.accept(String.format("No room was found between %s and %s", doorPos.getUIString(), wallPos.getUIString()));
            return Search.empty();
        }
        if (findAlt.isPresent() && room.get().getSpace().equals(findAlt.get())) {
            return Search.empty();
        }
        return room.map(RoomDetection::simplify);
    }

    private static Room simplify(Room v) {
        if (v.getSpaces().size() == 2) {
            ImmutableList s = ImmutableList.copyOf(v.getSpaces());
            ZWall ew = ((InclusiveSpace)s.get(0)).getEastZWall();
            ZWall ww = ((InclusiveSpace)s.get(1)).getWestZWall();
            if (ew.northCorner.equals(ww.northCorner) && ew.southCorner.equals(ww.southCorner)) {
                ZWall nww = ((InclusiveSpace)s.get(0)).getWestZWall();
                ZWall eww = ((InclusiveSpace)s.get(1)).getEastZWall();
                return new Room(v.getDoorPos(), InclusiveSpace.from(nww.northCorner).to(eww.southCorner));
            }
        }
        return v;
    }

    private static Search<Room> findRoomBetween(Position doorPos, Position wallPos, int maxDistFromDoor, int depth, Consumer<String> flightRecorder, WallDetector wd, ImmutableList<InclusiveSpace> spacesFoundAlready) {
        return RoomDetection.findRoomBetween(doorPos, wallPos, maxDistFromDoor, WallExclusion.mustHaveAllWalls(), depth + 1, flightRecorder, wd, spacesFoundAlready);
    }

    private static Search<Room> findRoomBetween(Position doorPos, Position wallPos, int maxDistFromDoor, WallExclusion exclusion, int depth, Consumer<String> flightRecorder, WallDetector wd, ImmutableList<InclusiveSpace> spacesFoundAlready) {
        if (doorPos.x != wallPos.x && doorPos.z != wallPos.z) {
            throw new IllegalStateException("Expected straight line between positions");
        }
        int diffX = Math.max(doorPos.x, wallPos.x) - Math.min(doorPos.x, wallPos.x);
        int diffZ = Math.max(doorPos.z, wallPos.z) - Math.min(doorPos.z, wallPos.z);
        if (diffZ > diffX) {
            return RoomDetection.findRoomWithDoor(Direction.NORTH, doorPos, wallPos, maxDistFromDoor, exclusion, depth + 1, flightRecorder, wd, ZWall::new, XWall::new, spacesFoundAlready);
        }
        return RoomDetection.findRoomWithDoor(Direction.WEST, doorPos, wallPos, maxDistFromDoor, exclusion, depth + 1, flightRecorder, wd, XWall::new, ZWall::new, spacesFoundAlready);
    }

    private static <W extends Wall<W>, W2 extends Wall<W2>> Search<Room> findRoomWithDoor(Direction doorSide, Position doorPos, Position wallPos, int maxDistFromDoor, WallExclusion exclusion, int depth, Consumer<String> flightRecorder, WallDetector wd, WallFactory<W> midWallFactory, WallFactory<W2> endWallsFactory, ImmutableList<InclusiveSpace> spacesFoundAlready) {
        RoomHints rh;
        if (doorPos.x != wallPos.x && doorPos.z != wallPos.z) {
            flightRecorder.accept("The door and the wall do not share coordinates. Skipping.");
            return Search.empty();
        }
        W midWall = midWallFactory.makeWall(doorPos, wallPos);
        int initialLength = midWall.getLengthOnAxis();
        if (initialLength > 1) {
            midWall = midWall.shortenNegative(1).shortenPositive(1);
        } else if (exclusion.allowOpenSouthWall || exclusion.allowOpenEastWall) {
            midWall = midWall.shortenNegative(1);
        } else if (exclusion.allowOpenNorthWall || exclusion.allowOpenWestWall) {
            midWall = midWall.shortenPositive(1);
        }
        flightRecorder.accept(String.format("Staged potential mid-wall %s due to exclusion policy %s", midWall.toShortString(), exclusion.toShortString()));
        if (Walls.isConnected(doorSide.cw(), midWall, wd)) {
            flightRecorder.accept("Potential mid-wall is not a wall");
            return Search.empty();
        }
        RoomHints roomHints = RoomHints.empty();
        for (int i = 1; i < maxDistFromDoor && !(rh = RoomDetection.findRoomFromCenterLine(midWall, doorSide, i, exclusion, roomHints, initialLength, flightRecorder, wd, endWallsFactory)).equals(roomHints); ++i) {
            roomHints = rh;
            if (!roomHints.isRoom(exclusion)) continue;
            return Search.from(roomHints.asRoom(doorPos, exclusion));
        }
        Optional<InclusiveSpace> asps = roomHints.asSpace(WallExclusion.allowAllOpen());
        if (asps.isPresent() && RoomDetection.alreadyFound(spacesFoundAlready, asps.get())) {
            flightRecorder.accept("Found adjoining room that is already accounted for. Must have gone in a circle. Stopping now.");
            return Search.of(new Room(doorPos, InclusiveSpace.from(doorPos).to(doorPos)));
        }
        if (roomHints.hasAnyOpenings()) {
            ImmutableList.Builder b = ImmutableList.builder();
            b.addAll(spacesFoundAlready);
            asps.ifPresent(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
            Search<Room> adjoined = RoomDetection.findAdjoiningRoom(roomHints, doorPos, maxDistFromDoor, depth + 1, flightRecorder, wd, spacesFoundAlready);
            if (adjoined.isPresent()) {
                return adjoined;
            }
        }
        return Search.empty();
    }

    private static Search<Room> findAdjoiningRoom(RoomHints roomHints, Position doorPos, int maxDistFromDoor, int depth, Consumer<String> flightRecorder, WallDetector wd, ImmutableList<InclusiveSpace> spacesFoundAlready) {
        InclusiveSpace ww;
        InclusiveSpace nn;
        Search<RoomHints> space;
        ImmutableList.Builder b;
        Optional<Object> n = Optional.empty();
        Optional<Object> s = Optional.empty();
        Optional<Object> e = Optional.empty();
        Optional<Object> w = Optional.empty();
        Optional<InclusiveSpace> space1 = roomHints.asSpace(WallExclusion.allowAllOpen());
        if (roomHints.northOpening != null) {
            flightRecorder.accept(String.format("An opening was detected on the north side of the room: -> %s <-", roomHints.toShortString()));
            b = ImmutableList.builder();
            b.addAll(spacesFoundAlready);
            space1.ifPresent(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
            space = RoomDetection.findNewRoomForXOpening(roomHints.northOpening, maxDistFromDoor, -1, (wall, hints) -> new RoomHints(wall, roomHints.northOpening, null, null, null, roomHints.northOpening, null, null), flightRecorder, WallExclusion.allowSouthOpen(), wd, (ImmutableList<InclusiveSpace>)b.build());
            if (space.isPresent()) {
                if (RoomDetection.isLoopEnd(space)) {
                    return Search.end(roomHints.asRoom(doorPos, WallExclusion.allowAllOpen()).get());
                }
                n = roomHints.adjoinedTo(doorPos, space.get());
            }
        }
        if (roomHints.southOpening != null) {
            flightRecorder.accept(String.format("An opening was detected on the south side of the room: -> %s <-", roomHints.toShortString()));
            b = ImmutableList.builder();
            b.addAll(spacesFoundAlready);
            space1.ifPresent(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
            space = RoomDetection.findNewRoomForXOpening(roomHints.southOpening, maxDistFromDoor, 1, (wall, hints) -> new RoomHints(roomHints.southOpening, wall, null, null, roomHints.southOpening, null, null, null), flightRecorder, WallExclusion.allowNorthOpen(), wd, (ImmutableList<InclusiveSpace>)b.build());
            if (space.isPresent()) {
                if (RoomDetection.isLoopEnd(space)) {
                    return Search.end(roomHints.asRoom(doorPos, WallExclusion.allowAllOpen()).get());
                }
                s = roomHints.adjoinedTo(doorPos, space.get());
            }
        }
        if (roomHints.westOpening != null) {
            flightRecorder.accept(String.format("An opening was detected on the west side of the room: -> %s <-", roomHints.toShortString()));
            b = ImmutableList.builder();
            b.addAll(spacesFoundAlready);
            space1.ifPresent(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
            space = RoomDetection.findNewRoomForZOpening(roomHints.westOpening, maxDistFromDoor, -1, (wall, hints) -> new RoomHints(null, null, wall, roomHints.westOpening, null, null, null, roomHints.westOpening), WallExclusion.allowEastOpen(), flightRecorder, wd, (ImmutableList<InclusiveSpace>)b.build());
            if (space.isPresent()) {
                if (RoomDetection.isLoopEnd(space)) {
                    return Search.end(roomHints.asRoom(doorPos, WallExclusion.allowAllOpen()).get());
                }
                w = roomHints.adjoinedTo(doorPos, space.get());
            }
        }
        if (roomHints.eastOpening != null) {
            flightRecorder.accept(String.format("An opening was detected on the east side of the room: -> %s <-", roomHints.toShortString()));
            b = ImmutableList.builder();
            b.addAll(spacesFoundAlready);
            space1.ifPresent(arg_0 -> ((ImmutableList.Builder)b).add(arg_0));
            space = RoomDetection.findNewRoomForZOpening(roomHints.eastOpening, maxDistFromDoor, 1, (wall, hints) -> new RoomHints(null, null, null, wall, null, null, roomHints.eastOpening, null), WallExclusion.allowWestOpen(), flightRecorder, wd, (ImmutableList<InclusiveSpace>)b.build());
            if (space.isPresent()) {
                if (RoomDetection.isLoopEnd(space)) {
                    return Search.end(roomHints.asRoom(doorPos, WallExclusion.allowAllOpen()).get());
                }
                e = roomHints.adjoinedTo(doorPos, space.get());
            }
        }
        if (roomHints.northOpening != null && roomHints.southOpening != null && n.isPresent() && s.isPresent()) {
            nn = (InclusiveSpace)n.get();
            InclusiveSpace ss = (InclusiveSpace)s.get();
            return Search.from(roomHints.asRoom(doorPos, new WallExclusion(false, false, true, true)).map(v -> v.withExtraSpace(nn).withExtraSpace(ss)));
        }
        if (roomHints.northOpening != null && n.isPresent()) {
            nn = (InclusiveSpace)n.get();
            return Search.from(roomHints.asRoom(doorPos, WallExclusion.allowAllOpen()).map(v -> v.withExtraSpace(nn)));
        }
        if (roomHints.southOpening != null && s.isPresent()) {
            InclusiveSpace ss = (InclusiveSpace)s.get();
            return Search.from(roomHints.asRoom(doorPos, WallExclusion.allowAllOpen()).map(v -> v.withExtraSpace(ss)));
        }
        if (roomHints.westOpening != null && roomHints.eastOpening != null && w.isPresent() && e.isPresent()) {
            ww = (InclusiveSpace)w.get();
            InclusiveSpace ee = (InclusiveSpace)e.get();
            return Search.from(roomHints.asRoom(doorPos, new WallExclusion(true, true, false, false)).map(v -> v.withExtraSpace(ww).withExtraSpace(ee)));
        }
        if (roomHints.westOpening != null && w.isPresent()) {
            ww = (InclusiveSpace)w.get();
            return Search.from(roomHints.asRoom(doorPos, WallExclusion.allowAllOpen()).map(v -> v.withExtraSpace(ww)));
        }
        if (roomHints.eastOpening != null && e.isPresent()) {
            InclusiveSpace ee = (InclusiveSpace)e.get();
            return Search.from(roomHints.asRoom(doorPos, WallExclusion.allowAllOpen()).map(v -> v.withExtraSpace(ee)));
        }
        return Search.empty();
    }

    private static boolean isLoopEnd(Search<RoomHints> space) {
        if (space.isEnd()) {
            return true;
        }
        Optional<InclusiveSpace> zpc = space.get().asSpace(WallExclusion.allowAllOpen());
        return InclusiveSpaces.calculateArea(zpc.get()) == 1.0;
    }

    private static boolean alreadyFound(ImmutableList<InclusiveSpace> spacesFoundAlready, InclusiveSpace ss) {
        for (InclusiveSpace inclusiveSpace : spacesFoundAlready) {
            if (!InclusiveSpaces.fullyContains(inclusiveSpace, ss)) continue;
            return true;
        }
        return false;
    }

    private static Search<RoomHints> findNewRoomForXOpening(XWall opening, int maxDistFromDoor, int z, OpeningXHintFactory factory, Consumer<String> flightRecorder, WallExclusion exclusion, WallDetector wd, ImmutableList<InclusiveSpace> spacesFoundAlready) {
        if (z == 0) {
            return Search.empty();
        }
        flightRecorder.accept(String.format("Trying some basic push checks", opening.toShortString(), exclusion.toShortString()));
        XWall wallMaybe = opening.shiftedPositive(z);
        boolean hasXWall = XWalls.isConnected(wallMaybe, wd);
        ZWall negSideMaybe = new ZWall(wallMaybe.westCorner, opening.westCorner);
        boolean haswestWall = ZWalls.isConnected(negSideMaybe, wd);
        ZWall posSideMaybe = new ZWall(wallMaybe.eastCorner, opening.eastCorner);
        boolean haseastWall = ZWalls.isConnected(posSideMaybe, wd);
        if (hasXWall && haswestWall && haseastWall) {
            flightRecorder.accept("Found a wall by pushing out by " + z);
            RoomHints base = RoomHints.empty().withWestWall(negSideMaybe).withEastWall(posSideMaybe);
            if (z < 0) {
                return Search.of(base.withNorthWall(wallMaybe).withSouthOpening(opening));
            }
            return Search.of(base.withNorthOpening(opening).withSouthWall(wallMaybe));
        }
        flightRecorder.accept(String.format("Treating opening %s like a door and searching for a room [Exlusion %s]", opening.toShortString(), exclusion.toShortString()));
        RoomHints hints = RoomHints.empty();
        for (int i = 1; i < maxDistFromDoor; ++i) {
            int zShift = i * z;
            XWall shifted = opening.shiftedSouthBy(zShift);
            if (XWalls.isConnected(shifted, wd)) {
                hints = factory.applyXWall(shifted, hints);
                break;
            }
            if (!opening.isSameContentAs(shifted, wd)) break;
        }
        Position mp = opening.getMidpoint();
        for (int i = 1; i < maxDistFromDoor; ++i) {
            int zShift = i * z;
            Search<Room> room = RoomDetection.findRoomFromBackWall(mp, mp.offset(0, zShift), maxDistFromDoor, Optional.empty(), exclusion, 0, flightRecorder, wd, spacesFoundAlready);
            if (!room.isPresent()) continue;
            return room.map(v -> new RoomHints(v.getSpace().getNorthXWall(), v.getSpace().getSouthXWall(), v.getSpace().getWestZWall(), v.getSpace().getEastZWall(), XWalls.findOpening(v.getSpace().getNorthXWall(), wd).orElse(null), XWalls.findOpening(v.getSpace().getSouthXWall(), wd).orElse(null), ZWalls.findOpening(v.getSpace().getWestZWall(), wd, true, true).orElse(null), ZWalls.findOpening(v.getSpace().getEastZWall(), wd, true, true).orElse(null)));
        }
        if (hints.northWall == null || hints.southWall == null) {
            return Search.empty();
        }
        ZWall westWall = new ZWall(hints.northWall.westCorner, hints.southWall.westCorner);
        ZWall eastWall = new ZWall(hints.northWall.eastCorner, hints.southWall.eastCorner);
        if (ZWalls.isConnected(westWall, wd) && ZWalls.isConnected(eastWall, wd)) {
            return Search.of(hints);
        }
        return Search.empty();
    }

    private static Search<RoomHints> findNewRoomForZOpening(ZWall opening, int maxDistFromDoor, int x, OpeningZHintFactory factory, WallExclusion exclusion, Consumer<String> flightRecorder, WallDetector wd, ImmutableList<InclusiveSpace> spacesFoundAlready) {
        if (x == 0) {
            return Search.empty();
        }
        flightRecorder.accept(String.format("Trying some basic push checks from %s", opening.toShortString()));
        ZWall wallMaybe = opening.shiftedPositive(x);
        boolean hasXWall = ZWalls.isConnected(wallMaybe, wd);
        XWall negSideMaybe = new XWall(wallMaybe.northCorner, opening.northCorner);
        boolean hasNorthWall = XWalls.isConnected(negSideMaybe, wd);
        XWall posSideMaybe = new XWall(wallMaybe.southCorner, opening.southCorner);
        boolean hasSouthWall = XWalls.isConnected(posSideMaybe, wd);
        if (hasXWall && hasNorthWall && hasSouthWall) {
            flightRecorder.accept("Found a wall by pushing out by " + x);
            RoomHints base = RoomHints.empty().withNorthWall(negSideMaybe).withSouthWall(posSideMaybe);
            if (x < 0) {
                return Search.of(base.withWestWall(wallMaybe).withEastOpening(opening));
            }
            return Search.of(base.withWestOpening(opening).withEastWall(wallMaybe));
        }
        flightRecorder.accept(String.format("Treating opening %s like a door and searching for a room [Exlusion %s]", opening.toShortString(), exclusion.toShortString()));
        Position mp = opening.getMidpoint();
        for (int i = 1; i < maxDistFromDoor; ++i) {
            int xShift = i * x;
            Search<Room> room = RoomDetection.findRoomFromBackWall(mp, mp.offset(xShift, 0), maxDistFromDoor, Optional.empty(), exclusion, 0, flightRecorder, wd, spacesFoundAlready);
            if (!room.isPresent()) continue;
            return room.map(v -> new RoomHints(v.getSpace().getNorthXWall(), v.getSpace().getSouthXWall(), v.getSpace().getWestZWall(), v.getSpace().getEastZWall(), XWalls.findOpening(v.getSpace().getNorthXWall(), wd).orElse(null), XWalls.findOpening(v.getSpace().getSouthXWall(), wd).orElse(null), ZWalls.findOpening(v.getSpace().getWestZWall(), wd, true, true).orElse(null), ZWalls.findOpening(v.getSpace().getEastZWall(), wd, true, true).orElse(null)));
        }
        return Search.empty();
    }

    private static <W extends Wall<W>, W2 extends Wall<W2>> RoomHints findRoomFromCenterLine(W midWall, Direction doorWall, int i, WallExclusion exclusion, RoomHints roomHints, int initialLength, Consumer<String> flightRecorder, WallDetector wd, WallFactory<W2> wf) {
        flightRecorder.accept(String.format("Searching outward from %s [iteration %d]", midWall.toShortString(), i));
        Direction wallA = doorWall.ccw();
        Direction wallB = wallA.opp();
        Direction backWall = doorWall.opp();
        RoomHints hints = roomHints.copy();
        hints = RoomDetection.getRoomHints(midWall, i, initialLength, exclusion, wd, hints, wallA);
        hints = RoomDetection.getRoomHints(midWall, i, initialLength, exclusion, wd, hints, wallB);
        if (hints.getWall(wallA) == null && hints.getOpening(wallA) == null || hints.getWall(wallB) == null && hints.getOpening(wallB) == null) {
            return hints;
        }
        Position nw = hints.getWall(wallA) != null ? hints.getWall(wallA).negativeCorner() : hints.getOpening(wallA).negativeCorner();
        Position ne = hints.getWall(wallA) != null ? hints.getWall(wallA).positiveCorner() : hints.getOpening(wallA).positiveCorner();
        Position sw = hints.getWall(wallB) != null ? hints.getWall(wallB).negativeCorner() : hints.getOpening(wallB).negativeCorner();
        Position se = hints.getWall(wallB) != null ? hints.getWall(wallB).positiveCorner() : hints.getOpening(wallB).positiveCorner();
        W2 pNegWall = wf.makeWall(nw, sw);
        pNegWall = pNegWall.shortenNegative(1).shortenPositive(1);
        if (hints.getWall(doorWall) == null && Walls.isConnected(doorWall, pNegWall, wd) && (hints = hints.withWall(doorWall, (Wall<?>)pNegWall.extendNegative(1).extendPositive(1))).isRoom(exclusion)) {
            return hints;
        }
        W2 pEastWall = wf.makeWall(ne, se);
        pEastWall = pEastWall.shortenNegative(1).shortenPositive(1);
        if (hints.getWall(backWall) == null && Walls.isConnected(backWall, pEastWall, wd) && (hints = hints.withWall(backWall, (Wall<?>)pEastWall.extendNegative(1).extendPositive(1))).isRoom(exclusion)) {
            return hints;
        }
        return hints;
    }

    private static <W extends Wall<W>> RoomHints getRoomHints(W midWall, int i, int initialLength, WallExclusion exclusion, WallDetector wd, RoomHints hints, Direction dir) {
        Wall<?> opening1 = hints.getOpening(dir);
        if (hints.getWall(dir) == null || opening1 != null && opening1.sameLengthOnAxis(hints.getWall(dir))) {
            Wall<?> pNegWall = midWall.shifted(dir, i);
            Object metaNegWall = pNegWall;
            if (initialLength >= 2) {
                metaNegWall = metaNegWall.extendNegative(1).extendPositive(1);
            } else if (exclusion.allowOpenSouthWall || exclusion.allowOpenEastWall) {
                metaNegWall = metaNegWall.extendNegative(1);
            } else if (exclusion.allowOpenNorthWall || exclusion.allowOpenWestWall) {
                metaNegWall = metaNegWall.extendPositive(1);
            }
            if (Walls.isConnected(dir, pNegWall, wd)) {
                hints = hints.withWall(dir, (Wall<?>)metaNegWall);
                hints = hints.withOpening(dir, null);
                hints = hints.withWall(dir.ccw(), null);
                hints = hints.withWall(dir.cw(), null);
            } else {
                Optional<Wall<?>> opening = Walls.findOpening(dir, metaNegWall, wd, !exclusion.allowOpenNorthWall && !exclusion.allowOpenWestWall, !exclusion.allowOpenSouthWall && !exclusion.allowOpenEastWall);
                if (opening.isPresent()) {
                    if (opening1 != null && opening1.isLargerOnAxis(opening.get())) {
                        hints = hints.withOpening(dir, opening.get());
                        hints = hints.withWall(dir, (Wall<?>)metaNegWall);
                        hints = hints.withWall(dir.ccw(), null);
                        hints = hints.withWall(dir.cw(), null);
                    } else if (opening.get().sameLengthOnAxis((Wall<?>)metaNegWall)) {
                        hints = hints.withOpening(dir, opening.get());
                        hints = hints.withWall(dir.ccw(), null);
                        hints = hints.withWall(dir.cw(), null);
                    } else if (hints.getOpening(dir) == null || hints.getOpening(dir).isSameContentOnAxis(opening.get(), wd)) {
                        hints = hints.withWall(dir, (Wall<?>)metaNegWall);
                        hints = hints.withOpening(dir, opening.get());
                    }
                }
            }
        }
        return hints;
    }

    static class SearchRange {
        final Integer minNorthZ;
        final Integer maxSouthZ;
        final Integer minWestZ;
        final Integer maxEastZ;

        public SearchRange(@Nullable Integer minNorthZ, @Nullable Integer maxSouthZ, @Nullable Integer minWestZ, @Nullable Integer maxEastZ) {
            this.minNorthZ = minNorthZ;
            this.maxSouthZ = maxSouthZ;
            this.minWestZ = minWestZ;
            this.maxEastZ = maxEastZ;
        }

        public static SearchRange outermost() {
            return new SearchRange(null, null, null, null);
        }
    }

    public static class WallExclusion {
        public final boolean allowOpenWestWall;
        public final boolean allowOpenEastWall;
        public final boolean allowOpenNorthWall;
        public final boolean allowOpenSouthWall;

        public static WallExclusion mustHaveAllWalls() {
            return new WallExclusion(false, false, false, false);
        }

        public static WallExclusion allowAllOpen() {
            return new WallExclusion(true, true, true, true);
        }

        public static WallExclusion allowWestOpen() {
            return new WallExclusion(true, false, false, false);
        }

        public static WallExclusion allowEastOpen() {
            return new WallExclusion(false, true, false, false);
        }

        public static WallExclusion allowNorthOpen() {
            return new WallExclusion(false, false, true, false);
        }

        public static WallExclusion allowSouthOpen() {
            return new WallExclusion(false, false, false, true);
        }

        public WallExclusion(boolean allowOpenWestWall, boolean allowOpenEastWall, boolean allowOpenNorthWall, boolean allowOpenSouthWall) {
            this.allowOpenWestWall = allowOpenWestWall;
            this.allowOpenEastWall = allowOpenEastWall;
            this.allowOpenNorthWall = allowOpenNorthWall;
            this.allowOpenSouthWall = allowOpenSouthWall;
        }

        public String toShortString() {
            return String.format("N: %s, S: %s, E: %s, W: %s", this.allowOpenNorthWall ? "allow-open" : "must-close", this.allowOpenSouthWall ? "allow-open" : "must-close", this.allowOpenEastWall ? "allow-open" : "must-close", this.allowOpenWestWall ? "allow-open" : "must-close");
        }
    }

    private static interface WallFactory<W extends Wall<W>> {
        public W makeWall(Position var1, Position var2);
    }

    private static interface OpeningXHintFactory {
        public RoomHints applyXWall(XWall var1, RoomHints var2);
    }

    private static interface OpeningZHintFactory {
        public RoomHints applyZWall(ZWall var1, RoomHints var2);
    }
}

