/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Search<T> {
    @Nullable
    private final T room;
    private final boolean end;

    private Search(T room, boolean end) {
        this.room = room;
        this.end = end;
    }

    public static <T> Search<T> end(T room) {
        return new Search<T>(room, true);
    }

    public static <X> Search<X> from(Optional<X> room) {
        return new Search<Object>(room.orElse(null), false);
    }

    public static <X> Search<X> empty() {
        return new Search<Object>(null, false);
    }

    public static <X> Search<X> of(X room) {
        return new Search<X>(room, false);
    }

    public boolean isPresent() {
        return this.room != null;
    }

    public boolean isEmpty() {
        return this.room == null;
    }

    public T get() {
        return this.room;
    }

    public <U> Search<U> map(Function<? super T, ? extends U> mapper) {
        T u = Optional.ofNullable(this.room).map(mapper).orElse(null);
        return new Search<Object>(u, this.end);
    }

    public Optional<T> toOptional() {
        return Optional.ofNullable(this.room);
    }

    public boolean isEnd() {
        return this.end;
    }
}

