/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.XWalls;
import ca.bradj.roomrecipes.logic.ZWalls;
import ca.bradj.roomrecipes.logic.interfaces.WallDetector;
import ca.bradj.roomrecipes.rooms.XWall;
import ca.bradj.roomrecipes.rooms.ZWall;
import java.util.Optional;

public class WallDetection {
    public static Optional<ZWall> findNorthToSouthWall(int maxDistFromDoor, WallDetector wd, Position doorPos) {
        Position op;
        int i;
        int northCornerZ = Integer.MAX_VALUE;
        int southCornerZ = -2147483647;
        boolean started = false;
        for (i = 0; i < maxDistFromDoor; ++i) {
            op = doorPos.offset(0, i);
            if (wd.IsWall(op)) {
                started = true;
                northCornerZ = Math.min(northCornerZ, op.z);
                southCornerZ = Math.max(southCornerZ, op.z);
                continue;
            }
            if (started) break;
        }
        for (i = 0; i < maxDistFromDoor; ++i) {
            op = doorPos.offset(0, -i);
            if (wd.IsWall(op)) {
                started = true;
                northCornerZ = Math.min(northCornerZ, op.z);
                southCornerZ = Math.max(southCornerZ, op.z);
                continue;
            }
            if (started) break;
        }
        if (!started) {
            return Optional.empty();
        }
        if (Math.abs(southCornerZ - northCornerZ) < 2) {
            return Optional.empty();
        }
        return Optional.of(new ZWall(doorPos.WithZ(northCornerZ), doorPos.WithZ(southCornerZ)));
    }

    public static Optional<XWall> findEastToWestWall(int maxDistFromDoor, WallDetector wd, Position doorPos) {
        Position op;
        int i;
        int westCornerX = Integer.MAX_VALUE;
        int eastCornerX = -2147483647;
        boolean started = false;
        for (i = 1; i < maxDistFromDoor; ++i) {
            op = doorPos.offset(i, 0);
            if (wd.IsWall(op)) {
                started = true;
                westCornerX = Math.min(westCornerX, op.x);
                eastCornerX = Math.max(eastCornerX, op.x);
                continue;
            }
            if (started) break;
        }
        for (i = 1; i < maxDistFromDoor; ++i) {
            op = doorPos.offset(-i, 0);
            if (wd.IsWall(op)) {
                started = true;
                westCornerX = Math.min(westCornerX, op.x);
                eastCornerX = Math.max(eastCornerX, op.x);
                continue;
            }
            if (started) break;
        }
        if (!started) {
            return Optional.empty();
        }
        if (Math.abs(eastCornerX - westCornerX) < 2) {
            return Optional.empty();
        }
        return Optional.of(new XWall(doorPos.WithX(westCornerX), doorPos.WithX(eastCornerX)));
    }

    public static Optional<ZWall> findParallelRoomZWall(int maxDistFromDoor, ZWall doorWall, WallDetector wd) {
        return WallDetection.findParallelRoomZWall(maxDistFromDoor, doorWall, Optional.empty(), wd);
    }

    public static Optional<ZWall> findParallelRoomZWall(int maxDistFromDoor, ZWall doorWall, Optional<Room> findAlternativeTo, WallDetector wd) {
        Optional<ZWall> northWall;
        if (!WallDetection.alreadyFoundEast(findAlternativeTo) && (northWall = WallDetection.findEastParallelZWall(doorWall, maxDistFromDoor, wd)).isPresent()) {
            return northWall;
        }
        return WallDetection.findWestParallelZWall(doorWall, maxDistFromDoor, wd);
    }

    private static Optional<ZWall> findEastParallelZWall(ZWall doorWall, int maxDistFromDoor, WallDetector wd) {
        for (int i = 2; i < maxDistFromDoor; ++i) {
            ZWall shifted = doorWall.shiftedEast(i);
            if (!ZWalls.isConnected(shifted, wd)) continue;
            return Optional.of(shifted);
        }
        return Optional.empty();
    }

    private static boolean alreadyFoundEast(Optional<Room> room) {
        if (room.isEmpty()) {
            return false;
        }
        return room.get().getSpace().getEastX() > room.get().getDoorPos().x;
    }

    private static Optional<ZWall> findWestParallelZWall(ZWall doorWall, int maxDistFromDoor, WallDetector wd) {
        for (int i = 2; i < maxDistFromDoor; ++i) {
            ZWall shifted = doorWall.shiftedWest(i);
            if (!ZWalls.isConnected(shifted, wd)) continue;
            return Optional.of(shifted);
        }
        return Optional.empty();
    }

    public static Optional<XWall> findParallelRoomXWall(int maxDistFromDoor, WallDetector wd, XWall wall) {
        return WallDetection.findParallelRoomXWall(maxDistFromDoor, Optional.empty(), wd, wall);
    }

    public static Optional<XWall> findParallelRoomXWall(int maxDistFromDoor, Optional<Room> findAlt, WallDetector wd, XWall wall) {
        Optional<XWall> northWall;
        if (!WallDetection.alreadyFoundNorth(findAlt) && (northWall = WallDetection.findNorthParallelXWall(maxDistFromDoor, wall, wd)).isPresent()) {
            return northWall;
        }
        return WallDetection.findSouthParallelXWall(maxDistFromDoor, wall, wd);
    }

    private static boolean alreadyFoundNorth(Optional<Room> room) {
        if (room.isEmpty()) {
            return false;
        }
        return room.get().getSpace().getNorthZ() < room.get().getDoorPos().z;
    }

    private static Optional<XWall> findSouthParallelXWall(int maxDistFromDoor, XWall wall, WallDetector wd) {
        for (int i = 2; i < maxDistFromDoor; ++i) {
            XWall shifted = wall.shiftedSouthBy(i);
            if (!XWalls.isConnected(shifted, wd)) continue;
            return Optional.of(shifted);
        }
        return Optional.empty();
    }

    private static Optional<XWall> findNorthParallelXWall(int maxDistFromDoor, XWall wall, WallDetector wd) {
        for (int i = 2; i < maxDistFromDoor; ++i) {
            XWall shifted = wall.shiftedNorthBy(i);
            if (!XWalls.isConnected(shifted, wd)) continue;
            return Optional.of(shifted);
        }
        return Optional.empty();
    }
}

