/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.Direction;
import ca.bradj.roomrecipes.logic.InclusiveSpaces;
import ca.bradj.roomrecipes.logic.ZWalls;
import ca.bradj.roomrecipes.rooms.ZWall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallPositionToRooms {
    private final int limit;
    private Consumer<String> flightRecorder = str -> {};

    public WallPositionToRooms() {
        this(1000);
    }

    public WallPositionToRooms(int limit) {
        this.limit = limit;
    }

    public ImmutableList<InclusiveSpace> getSpaces(Set<Position> positions) {
        ImmutableList<InclusiveSpace> space = this.getSpaceFromOuterBorder(positions);
        if (!space.isEmpty()) {
            return space;
        }
        return this.getSpacesByClampingWalls(positions);
    }

    private ImmutableList<InclusiveSpace> getSpaceFromOuterBorder(Set<Position> positions) {
        if (positions.isEmpty()) {
            this.flightRecorder.accept("No border positions provided. Space cannot be found.");
            return ImmutableList.of();
        }
        OptionalInt leftX = positions.stream().mapToInt(v -> v.x).min();
        OptionalInt topY = positions.stream().mapToInt(v -> v.z).min();
        OptionalInt rightX = positions.stream().mapToInt(v -> v.x).max();
        OptionalInt bottomY = positions.stream().mapToInt(v -> v.z).max();
        if (leftX.getAsInt() >= rightX.getAsInt() - 1) {
            this.flightRecorder.accept("Parallel sides too close on X axis. Space cannot be found");
            return ImmutableList.of();
        }
        if (topY.getAsInt() >= bottomY.getAsInt() - 1) {
            this.flightRecorder.accept("Parallel sides too close on Z axis. Space cannot be found");
            return ImmutableList.of();
        }
        InclusiveSpace outer = InclusiveSpace.from(leftX.getAsInt(), topY.getAsInt()).to(rightX.getAsInt(), bottomY.getAsInt());
        this.flightRecorder.accept("Checking if the outer walls can be used to define a room: " + InclusiveSpaces.getShortString(outer));
        if (!positions.containsAll((Collection<?>)InclusiveSpaces.getWallPositions(outer, false))) {
            this.flightRecorder.accept("Positions are not a complete room border: " + Positions.getUIString(positions));
            this.flightRecorder.accept("Space cannot be found");
            return ImmutableList.of();
        }
        InclusiveSpace nextLevel = InclusiveSpace.from(outer.getCornerA().offset(1, 1)).to(outer.getCornerB().offset(-1, -1));
        ImmutableSet<Position> nextRing = InclusiveSpaces.getWallPositions(nextLevel, true);
        Set nextRingWalls = nextRing.stream().filter(positions::contains).collect(Collectors.toSet());
        if (nextRingWalls.isEmpty()) {
            this.flightRecorder.accept("All spaces just-inside the outer walls are empty. This means the outer walls are a room.");
            return ImmutableList.of((Object)outer);
        }
        this.flightRecorder.accept("Some spaces just-inside the outer wall are NOT empty. More advanced space detection will be required");
        return ImmutableList.of();
    }

    @NotNull
    private ImmutableList<InclusiveSpace> getSpacesByClampingWalls(Set<Position> positions) {
        ImmutableList<InclusiveSpace> spaces = this.findOuterSpaces(positions);
        if (spaces.size() < 2) {
            return spaces;
        }
        spaces = this.tryToInsertMiddleSpace(spaces);
        return spaces;
    }

    private ImmutableList<InclusiveSpace> tryToInsertMiddleSpace(ImmutableList<InclusiveSpace> spaces) {
        ToIntFunction<InclusiveSpace> avgX = s -> (int)InclusiveSpaces.getWallPositions(s).stream().mapToInt(v -> v.x).average().getAsDouble();
        ToIntFunction<InclusiveSpace> avgZ = s -> (int)InclusiveSpaces.getWallPositions(s).stream().mapToInt(v -> v.z).average().getAsDouble();
        InclusiveSpace westMost = spaces.stream().min(Comparator.comparingInt(avgX)).orElseThrow();
        InclusiveSpace eastMost = spaces.stream().max(Comparator.comparingInt(avgX)).orElseThrow();
        InclusiveSpace northMost = spaces.stream().min(Comparator.comparingInt(avgZ)).orElseThrow();
        InclusiveSpace southMost = spaces.stream().max(Comparator.comparingInt(avgZ)).orElseThrow();
        if (westMost.getEastX() >= eastMost.getWestX()) {
            this.flightRecorder.accept("No middle space can be found because the east space is connected to the west space");
            return spaces;
        }
        if (northMost.getSouthZ() >= southMost.getNorthZ()) {
            this.flightRecorder.accept("No middle space can be found because the south space is connected to the north space");
            return spaces;
        }
        InclusiveSpace middle = InclusiveSpace.from(westMost.getEastX(), northMost.getSouthZ()).to(eastMost.getWestX(), southMost.getNorthZ());
        this.flightRecorder.accept("Found middle space: " + InclusiveSpaces.getShortString(middle));
        ImmutableList.Builder builder = ImmutableList.builder();
        return builder.addAll(spaces).add((Object)middle).build();
    }

    @NotNull
    private ImmutableList<InclusiveSpace> findOuterSpaces(Set<Position> positions) {
        InclusiveSpace unspun;
        Position bb;
        Position a;
        this.flightRecorder.accept("Applying clamping strategy to find outer walls");
        ArrayList<InclusiveSpace> b = new ArrayList<InclusiveSpace>();
        HashSet<Position> coveredSoFar = new HashSet<Position>();
        ImmutableSet initPositions = ImmutableSet.copyOf(this.removeCorners((Set<Position>)positions));
        this.flightRecorder.accept("Checking east walls");
        InclusiveSpace rect = this.clampRect((Collection<Position>)positions);
        Sets.SetView difference = Sets.difference((Set)initPositions, (Set)initPositions);
        if (rect != null) {
            this.flightRecorder.accept("A space was detected on the outer border of the west walls: " + InclusiveSpaces.getShortString(rect));
            b.add(rect);
            coveredSoFar.addAll((Collection<Position>)InclusiveSpaces.getWallPositions(rect));
            difference = Sets.difference(positions, coveredSoFar);
            if (difference.isEmpty()) {
                this.flightRecorder.accept("There are no remaining walls to account for");
                return ImmutableList.copyOf(b);
            }
        }
        this.flightRecorder.accept("Checking west walls (by negating X/Z plane)");
        rect = this.clampRect(positions.stream().map(v -> new Position(-v.x, -v.z)).toList());
        if (rect != null) {
            a = rect.getCornerA();
            bb = rect.getCornerB();
            unspun = InclusiveSpace.from(-a.x, -a.z).to(-bb.x, -bb.z);
            this.flightRecorder.accept("A space was detected on the outer border of the east walls: " + InclusiveSpaces.getShortString(unspun));
            b.add(unspun);
            coveredSoFar.addAll((Collection<Position>)InclusiveSpaces.getWallPositions(unspun));
            difference = Sets.difference((Set)positions, coveredSoFar);
            if (difference.isEmpty()) {
                this.flightRecorder.accept("There are no remaining walls to account for");
                return ImmutableList.copyOf(b);
            }
        }
        this.flightRecorder.accept("Checking north walls (by pivoting X/Z plane)");
        positions = ImmutableSet.copyOf((Collection)initPositions);
        rect = this.clampRect(positions.stream().map(v -> new Position(v.z, v.x)).toList());
        if (rect != null) {
            a = rect.getCornerA();
            bb = rect.getCornerB();
            unspun = InclusiveSpace.from(a.z, a.x).to(bb.z, bb.x);
            this.flightRecorder.accept("A space was detected on the outer border of the north walls: " + InclusiveSpaces.getShortString(unspun));
            b.add(unspun);
            coveredSoFar.addAll((Collection<Position>)InclusiveSpaces.getWallPositions(unspun));
            difference = Sets.difference((Set)positions, coveredSoFar);
            if (difference.isEmpty()) {
                this.flightRecorder.accept("There are no remaining walls to account for");
                return ImmutableList.copyOf(b);
            }
        }
        this.flightRecorder.accept("Checking south walls (by pivoting and negating X/Z plane)");
        rect = this.clampRect(positions.stream().map(v -> new Position(-v.z, -v.x)).toList());
        if (rect != null) {
            a = rect.getCornerA();
            bb = rect.getCornerB();
            unspun = InclusiveSpace.from(-a.z, -a.x).to(-bb.z, -bb.x);
            this.flightRecorder.accept("A space was detected on the outer border of the south walls: " + InclusiveSpaces.getShortString(unspun));
            b.add(unspun);
            coveredSoFar.addAll((Collection<Position>)InclusiveSpaces.getWallPositions(unspun));
            difference = Sets.difference((Set)positions, coveredSoFar);
            if (difference.isEmpty()) {
                this.flightRecorder.accept("There are no remaining walls to account for");
                return ImmutableList.copyOf(b);
            }
        }
        for (Position position : difference) {
            this.flightRecorder.accept("Attempting to find space above position: " + position.getUIString());
            Set verticallyAligned = positions.stream().filter(v -> v.x == position.x).collect(Collectors.toSet());
            Optional<Position> above = verticallyAligned.stream().filter(v -> v.z < position.z - 1).max(Comparator.comparingInt(v -> v.z));
            if (!above.isPresent()) continue;
            this.flightRecorder.accept("Found position above: " + above.get().getUIString());
            InclusiveSpace e = InclusiveSpace.from(position.x, above.get().z).to(position.x, position.z);
            this.flightRecorder.accept("Adding space: " + InclusiveSpaces.getShortString(e));
            b.add(e);
            coveredSoFar.add(position);
            difference = Sets.difference((Set)positions, coveredSoFar);
            if (!difference.isEmpty()) continue;
            this.flightRecorder.accept("There are no remaining walls to account for");
            return ImmutableList.copyOf(b);
        }
        this.flightRecorder.accept("Unprocessed wall positions remain. Returning empty result. Remaining positions: " + Positions.getUIString((Set<Position>)difference.immutableCopy()));
        return ImmutableList.of();
    }

    private ImmutableSet<Position> removeCorners(Set<Position> positions) {
        OptionalInt minX = positions.stream().mapToInt(p -> p.x).min();
        OptionalInt minZ = positions.stream().mapToInt(p -> p.z).min();
        OptionalInt maxX = positions.stream().mapToInt(p -> p.x).max();
        OptionalInt maxZ = positions.stream().mapToInt(p -> p.z).max();
        return (ImmutableSet)positions.stream().filter(p -> p.x != minX.getAsInt() || p.z != minZ.getAsInt()).filter(p -> p.x != maxX.getAsInt() || p.z != minZ.getAsInt()).filter(p -> p.x != minX.getAsInt() || p.z != maxZ.getAsInt()).filter(p -> p.x != maxX.getAsInt() || p.z != maxZ.getAsInt()).collect(ImmutableSet.toImmutableSet());
    }

    private ImmutableList<InclusiveSpace> simplify(InclusiveSpace a, InclusiveSpace b) {
        if (a.getWestX() == b.getWestX() && a.getEastX() == b.getEastX()) {
            if (a.getNorthZ() == b.getSouthZ() || a.getSouthZ() == b.getNorthZ()) {
                return ImmutableList.of((Object)InclusiveSpace.from(a.getWestX(), a.getNorthZ()).to(a.getEastX(), b.getSouthZ()));
            }
        } else if (a.getNorthZ() == b.getNorthZ() && a.getSouthZ() == b.getSouthZ() && (a.getWestX() == b.getEastX() || a.getEastX() == b.getWestX())) {
            return ImmutableList.of((Object)InclusiveSpace.from(a.getWestX(), a.getNorthZ()).to(b.getEastX(), a.getSouthZ()));
        }
        return ImmutableList.of((Object)a, (Object)b);
    }

    @Nullable
    private InclusiveSpace clampRect(Collection<Position> positions) {
        InclusiveSpace rect = null;
        OptionalInt leftmost = positions.stream().mapToInt(p -> p.x).min();
        List<Position> leftside = positions.stream().filter(p -> p.x == leftmost.getAsInt()).sorted(Comparator.comparingInt(a -> a.z)).toList();
        if (leftside.isEmpty()) {
            return null;
        }
        Position topOfLeft = leftside.get(0);
        Direction dir = Direction.NORTH;
        Position lastChecked = topOfLeft;
        for (Position position : leftside) {
            if (position.equals(topOfLeft)) continue;
            if (position.relative(dir).equals(lastChecked)) {
                lastChecked = position;
                continue;
            }
            rect = this.clampDown(positions, dir.cw(), topOfLeft, lastChecked);
            if ((rect = this.findRectangle(positions, dir, rect)) != null) {
                return rect;
            }
            topOfLeft = null;
            lastChecked = null;
        }
        if (topOfLeft != null) {
            rect = this.clampDown(positions, dir.cw(), topOfLeft, lastChecked);
            rect = this.findRectangle(positions, dir, rect);
        }
        return rect;
    }

    private InclusiveSpace clampDown(Collection<Position> positions, Direction dir, Position topLeft, Position bottomLeft) {
        Position topRight = topLeft.relative(dir).relative(dir.ccw());
        Position bottomRight = bottomLeft.relative(dir).relative(dir.cw());
        this.flightRecorder.accept("Clamping down from " + topRight.getUIString() + " to " + bottomRight.getUIString() + " in " + dir + " direction");
        for (int i = -1; i < bottomRight.z - topRight.z; ++i) {
            boolean hadBot;
            Position iTR = topRight.relative(dir.cw(), 1);
            Position iBR = bottomRight.relative(dir.ccw(), 1);
            boolean hadTop = positions.contains(iTR);
            if (hadTop) {
                topRight = iTR;
                this.flightRecorder.accept("Clamped top-right to " + iTR.getUIString());
            }
            if (!(hadBot = positions.contains(iBR))) continue;
            bottomRight = iBR;
            this.flightRecorder.accept("Clamped bottom-right to " + iBR.getUIString());
        }
        InclusiveSpace rect = InclusiveSpace.from(topLeft.WithZ(topRight.z)).to(bottomRight);
        this.flightRecorder.accept("Found rectangle: " + InclusiveSpaces.getShortString(rect));
        return rect;
    }

    private InclusiveSpace findRectangle(Collection<Position> positions, Direction dir, InclusiveSpace space) {
        if (positions.size() <= 2) {
            return null;
        }
        Direction nextDir = dir.cw();
        this.flightRecorder.accept("Attempting to extend " + nextDir + "-ward from " + InclusiveSpaces.getShortString(space));
        Position top = space.getEastZWall().northCorner;
        Position bot = space.getEastZWall().southCorner;
        Position nextTop = top;
        Position nextBot = bot;
        for (int i = 0; i < this.limit; ++i) {
            Position prevBot = nextBot;
            if (positions.containsAll(ZWalls.getWallPositions(new ZWall(nextTop = nextTop.relative(nextDir), nextBot = nextBot.relative(nextDir))))) {
                this.flightRecorder.accept("Found connection between " + nextTop.getUIString() + " and " + nextBot.getUIString());
                return InclusiveSpace.from(space.getCornerA()).to(nextBot);
            }
            if (positions.contains(nextTop) && positions.contains(nextBot)) continue;
            if (i == 0) break;
            return InclusiveSpace.from(space.getCornerA()).to(prevBot);
        }
        return space;
    }

    public void setFlightRecorder(Consumer<String> flightRecorder) {
        this.flightRecorder = flightRecorder;
    }

    public void clearFlightRecorder() {
        this.flightRecorder = str -> {};
    }
}

