/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.Crawl;
import ca.bradj.roomrecipes.logic.Direction;
import ca.bradj.roomrecipes.logic.Rooms;
import ca.bradj.roomrecipes.logic.Search;
import ca.bradj.roomrecipes.logic.interfaces.WallDetector;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class WallWalkingRoomDetection {
    public static Search<ImmutableSet<Position>> tryFindWalls(final Position doorPos, int iteration, @Nullable Consumer<String> flightRecorder, final WallDetector wd) {
        ArrayList<Position> visitedSink = new ArrayList<Position>();
        if (flightRecorder == null) {
            flightRecorder = s -> {};
        }
        if (!wd.IsWall(doorPos)) {
            return Search.empty();
        }
        final Direction dir = Direction.fromNorthQuarter(iteration);
        Position checkPos = doorPos.relative(dir);
        flightRecorder.accept(String.format("Searching %s at %s for iteration %d from %s", new Object[]{dir, WallWalkingRoomDetection.sm(checkPos), iteration, WallWalkingRoomDetection.sm(doorPos)}));
        if (wd.IsWall(checkPos)) {
            flightRecorder.accept(String.format("Found wall at %s, continuing facing %s", new Object[]{WallWalkingRoomDetection.sm(checkPos), dir}));
            Crawl.Checks checks = new Crawl.Checks(){

                @Override
                public boolean isWall(Position pos) {
                    return wd.IsWall(pos);
                }

                @Override
                public boolean isOrigin(Position pos) {
                    return pos.equals(doorPos.relative(dir.opp())) || pos.equals(doorPos);
                }
            };
            ImmutableList<Crawl> crawls = Crawl.forwardSpread(checkPos, dir, checks, (Collection<Position>)ImmutableSet.of((Object)doorPos, (Object)checkPos), visitedSink);
            Search<ImmutableSet<Position>> result = WallWalkingRoomDetection.tryFindWalls(crawls, flightRecorder, 0, visitedSink);
            if (result.isEnd()) {
                return result;
            }
        }
        return Search.empty();
    }

    private static String sm(Position checkPos) {
        return checkPos.getUIString();
    }

    private static Search<ImmutableSet<Position>> tryFindWalls(Collection<Crawl> crawls, Consumer<String> flightRecorder, int depth, List<Position> visitedSink) {
        if (depth > 1000) {
            flightRecorder.accept("Reached max depth of 1000, giving up.");
            return Search.empty();
        }
        ImmutableList.Builder b = ImmutableList.builder();
        HashSet<Position> positions = new HashSet<Position>();
        for (Crawl crawl : crawls) {
            flightRecorder.accept(crawl.toString());
            if (crawl.isOrigin()) {
                ImmutableSet<Position> ps = crawl.getCheckedPositions();
                String allPositions = Positions.getUIString(ps);
                if (crawl.getWidth() < 3 || crawl.getHeight() < 3) {
                    flightRecorder.accept("Area too small. Ignoring crawl: " + allPositions);
                    continue;
                }
                flightRecorder.accept("Reached origin, recording wall positions:" + allPositions);
                positions.addAll((Collection<Position>)ps);
                continue;
            }
            ImmutableList<Crawl> nextSteps = crawl.getNextSteps(visitedSink);
            if (nextSteps.isEmpty()) continue;
            flightRecorder.accept("--> Detected wall <--");
            b.addAll(nextSteps);
        }
        if (!positions.isEmpty()) {
            String allPositions = Positions.getUIString(positions);
            flightRecorder.accept("One or more rooms found connected to door. Returning combined positions: " + allPositions);
            return Search.end(ImmutableSet.copyOf(positions));
        }
        crawls = b.build();
        if (crawls.isEmpty()) {
            return Search.empty();
        }
        return WallWalkingRoomDetection.tryFindWalls((Collection<Crawl>)crawls, flightRecorder, depth + 1, visitedSink);
    }

    public static Search<Room> tryFind(Position nextDoor, int iteration, @Nullable Consumer<String> flightRecorder, WallDetector wd) {
        Consumer<String> fr = flightRecorder == null ? s -> {} : flightRecorder;
        Search<ImmutableSet<Position>> walls = WallWalkingRoomDetection.tryFindWalls(nextDoor, iteration, flightRecorder, wd);
        Search<Room> map = walls.map(v -> Rooms.wallPositionsToSpaces((Set<Position>)v, fr)).map(v -> new Room(nextDoor, (Collection<InclusiveSpace>)v));
        if (walls.isPresent() && map.isPresent() && map.get().getSpaces().isEmpty()) {
            fr.accept("No spaces found for door " + nextDoor.getUIString() + " and wall positions: " + Positions.getUIString((Set)walls.get()));
        }
        return map;
    }
}

