/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.recipes;

import ca.bradj.roomrecipes.adapter.RoomRecipeMatches;
import ca.bradj.roomrecipes.core.space.ThreePosition;
import ca.bradj.roomrecipes.recipes.RecipeDetectionClean;
import ca.bradj.roomrecipes.recipes.RecipesInit;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class RecipeDetection {
    public static Optional<RoomRecipeMatches<MCRoom>> getActiveRecipes(Level level, MCRoom room, boolean getFarmRecipesOnly) {
        RecipeDetectionClean.Match<MCRoom, RoomRecipe, Block> activeRecipes = RecipeDetectionClean.getActiveRecipes(tp -> level.m_8055_(RecipeDetection.pos(tp)).m_60734_(), room, room.yCoord, room.yCoord + 1, () -> ImmutableList.copyOf((Collection)level.m_7465_().m_44013_(RecipesInit.ROOM)), (recipe, blocks) -> recipe.m_5818_((Container)RecipeDetection.simulateContainer((ImmutableList<Block>)blocks), level), recipe -> getFarmRecipesOnly || !recipe.isFarmRecipe());
        if (activeRecipes == null) {
            return Optional.empty();
        }
        return Optional.of(new RoomRecipeMatches<MCRoom>(activeRecipes.room(), (ImmutableList<ResourceLocation>)((ImmutableList)activeRecipes.recipeIDs().stream().map(RoomRecipe::m_6423_).collect(ImmutableList.toImmutableList())), RecipeDetection.pos(activeRecipes.containedBlocks())));
    }

    private static Iterable<Map.Entry<BlockPos, Block>> pos(Iterable<Map.Entry<ThreePosition, Block>> entries) {
        return Lists.transform((List)ImmutableList.copyOf(entries), e -> new AbstractMap.SimpleImmutableEntry<BlockPos, Block>(RecipeDetection.pos((ThreePosition)e.getKey()), (Block)e.getValue()));
    }

    @NotNull
    private static SimpleContainer simulateContainer(ImmutableList<Block> blocks) {
        ItemStack[] list = (ItemStack[])blocks.stream().map(b -> new ItemStack((ItemLike)b, 1)).toArray(ItemStack[]::new);
        return new SimpleContainer(list);
    }

    public static ImmutableMap<BlockPos, Block> getBlocksInRoom(Level level, MCRoom room, boolean includeWallBlocks) {
        return RecipeDetection.getBlocksInRoomV2(bp -> level.m_8055_(bp).m_60734_(), room, includeWallBlocks);
    }

    public static ImmutableMap<BlockPos, Block> getBlocksInRoomV2(Function<BlockPos, Block> level, MCRoom room, boolean includeWallBlocks) {
        ImmutableMap<ThreePosition, Block> blocks = RecipeDetectionClean.getBlocksInRoom(tp -> (Block)level.apply(RecipeDetection.pos(tp)), room.getSpaces(), room.yCoord, room.yCoord + 1);
        return ImmutableMap.copyOf((Iterable)Lists.transform((List)ImmutableList.copyOf((Collection)blocks.entrySet()), e -> new AbstractMap.SimpleImmutableEntry<BlockPos, Block>(RecipeDetection.pos((ThreePosition)e.getKey()), (Block)e.getValue())));
    }

    private static BlockPos pos(ThreePosition tp) {
        return new BlockPos(tp.getX(), tp.getY(), tp.getZ());
    }
}

