/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.rooms;

import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.Position;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ActiveRooms<ROOM extends Room> {
    private final Map<Position, ROOM> rooms = new HashMap<Position, ROOM>();
    private ChangeListener<ROOM> changeListener = new ChangeListener<ROOM>(){

        @Override
        public void roomAdded(Position doorPos, ROOM room) {
        }

        @Override
        public void roomResized(Position doorPos, ROOM oldRoom, ROOM newRoom) {
        }

        @Override
        public void roomDestroyed(Position doorPos, Room room) {
        }
    };

    public Collection<ROOM> getAll() {
        return this.rooms.values();
    }

    @Nullable
    public ROOM get(Position p) {
        return (ROOM)((Room)this.rooms.get(p));
    }

    public void addChangeListener(ChangeListener<ROOM> cl) {
        this.changeListener = cl;
    }

    public void update(Map<Position, Optional<ROOM>> rooms) {
        Map<Position, Optional> asOptional = this.rooms.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Optional.of((Room)e.getValue())));
        MapDifference diff = Maps.difference(asOptional, rooms);
        if (diff.areEqual()) {
            return;
        }
        Map oldEntries = diff.entriesOnlyOnLeft();
        for (Map.Entry removed : oldEntries.entrySet()) {
            if (((Optional)removed.getValue()).isEmpty()) {
                throw new IllegalStateException("Removing non-existent room");
            }
            this.changeListener.roomDestroyed((Position)removed.getKey(), (Room)((Optional)removed.getValue()).get());
        }
        Map newEntries = diff.entriesOnlyOnRight();
        for (Map.Entry entry : newEntries.entrySet()) {
            if (((Optional)entry.getValue()).isEmpty()) continue;
            this.changeListener.roomAdded((Position)entry.getKey(), (Room)((Optional)entry.getValue()).get());
        }
        Map changedEntries = diff.entriesDiffering();
        for (Map.Entry e2 : changedEntries.entrySet()) {
            MapDifference.ValueDifference v2 = (MapDifference.ValueDifference)e2.getValue();
            if (((Optional)v2.leftValue()).isPresent() && ((Optional)v2.rightValue()).isEmpty()) {
                this.changeListener.roomDestroyed((Position)e2.getKey(), (Room)((Optional)v2.leftValue()).get());
                continue;
            }
            if (((Optional)v2.leftValue()).isEmpty() && ((Optional)v2.rightValue()).isPresent()) {
                this.changeListener.roomAdded((Position)e2.getKey(), (Room)((Optional)v2.rightValue()).get());
                continue;
            }
            if (!((Optional)v2.leftValue()).isPresent() || !((Optional)v2.rightValue()).isPresent()) continue;
            this.changeListener.roomResized((Position)e2.getKey(), (Room)((Optional)v2.leftValue()).get(), (Room)((Optional)v2.rightValue()).get());
        }
        this.rooms.clear();
        rooms.entrySet().stream().filter(v -> ((Optional)v.getValue()).isPresent()).forEach(v -> this.rooms.put((Position)v.getKey(), (Room)((Optional)v.getValue()).get()));
    }

    public static interface ChangeListener<ROOM extends Room> {
        public void roomAdded(Position var1, ROOM var2);

        public void roomResized(Position var1, ROOM var2, ROOM var3);

        public void roomDestroyed(Position var1, ROOM var2);
    }
}

