/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.rooms;

import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.Direction;
import ca.bradj.roomrecipes.logic.interfaces.WallDetector;
import ca.bradj.roomrecipes.rooms.Wall;
import ca.bradj.roomrecipes.rooms.XWall;
import java.util.Objects;
import java.util.Optional;

public class ZWall
implements Wall<ZWall> {
    public final Position northCorner;
    public final Position southCorner;

    public ZWall(Position northCorner, Position southCorner) {
        Position nc = northCorner;
        Position sc = southCorner;
        if (nc.z > sc.z) {
            nc = southCorner;
            sc = northCorner;
        }
        this.northCorner = nc;
        this.southCorner = sc;
    }

    public static Optional<ZWall> northFromCorner(WallDetector wd, Position cornerPos, int maxDistFromCorner) {
        int southCornerZ = -2147483647;
        int northCornerZ = Integer.MAX_VALUE;
        boolean started = false;
        for (int i = 0; i < maxDistFromCorner; ++i) {
            Position op = cornerPos.offset(0, -i);
            if (wd.IsWall(op)) {
                started = true;
                southCornerZ = Math.max(southCornerZ, op.z);
                northCornerZ = Math.min(northCornerZ, op.z);
                continue;
            }
            if (started) break;
        }
        if (!started) {
            return Optional.empty();
        }
        if (Math.abs(northCornerZ - southCornerZ) < 2) {
            return Optional.empty();
        }
        return Optional.of(new ZWall(cornerPos.WithZ(southCornerZ), cornerPos.WithZ(northCornerZ)));
    }

    public static Optional<ZWall> southFromCorner(WallDetector wd, Position doorPos, int maxDistFromCorner) {
        int southCornerZ = -2147483647;
        int northCornerZ = Integer.MAX_VALUE;
        boolean started = false;
        for (int i = 0; i < maxDistFromCorner; ++i) {
            Position op = doorPos.offset(0, i);
            if (wd.IsWall(op)) {
                started = true;
                southCornerZ = Math.max(southCornerZ, op.z);
                northCornerZ = Math.min(northCornerZ, op.z);
                continue;
            }
            if (started) break;
        }
        if (!started) {
            return Optional.empty();
        }
        if (Math.abs(northCornerZ - southCornerZ) < 2) {
            return Optional.empty();
        }
        return Optional.of(new ZWall(doorPos.WithZ(southCornerZ), doorPos.WithZ(northCornerZ)));
    }

    public int getLength() {
        return this.southCorner.z - this.northCorner.z;
    }

    public ZWall shortenSouthEnd(int i) {
        return new ZWall(this.northCorner, this.southCorner.WithZ(this.southCorner.z - i));
    }

    public ZWall shortenNorthEnd(int i) {
        return new ZWall(this.northCorner.WithZ(this.northCorner.z + i), this.southCorner);
    }

    public ZWall extendSouthEnd(int i) {
        return this.shortenSouthEnd(-i);
    }

    public ZWall extendNorthEnd(int i) {
        return this.shortenNorthEnd(-i);
    }

    public ZWall shiftedWest(int i) {
        return this.shiftedEast(-i);
    }

    public ZWall shiftedEast(int i) {
        return new ZWall(this.northCorner.offset(i, 0), this.southCorner.offset(i, 0));
    }

    public String toString() {
        return "ZWall{northCorner=" + this.northCorner + ", southCorner=" + this.southCorner + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZWall zWall = (ZWall)o;
        return Objects.equals(this.northCorner, zWall.northCorner) && Objects.equals(this.southCorner, zWall.southCorner);
    }

    public int hashCode() {
        return Objects.hash(this.northCorner, this.southCorner);
    }

    public Position getMidpoint() {
        return new Position(this.northCorner.x, (this.northCorner.z + this.southCorner.z) / 2);
    }

    public boolean sameHeight(ZWall wall) {
        return this.northCorner.z == wall.northCorner.z && this.southCorner.z == wall.southCorner.z;
    }

    public boolean isSameContentAs(ZWall shifted, WallDetector wd) {
        for (int i = 0; i < shifted.southCorner.z; ++i) {
            boolean shiftedIsWall;
            boolean isWall = wd.IsWall(this.northCorner.offset(0, i));
            if (isWall == (shiftedIsWall = wd.IsWall(shifted.northCorner.offset(0, i)))) continue;
            return false;
        }
        return true;
    }

    public int getX() {
        return this.northCorner.x;
    }

    public boolean isLargerThan(ZWall zWall) {
        return this.southCorner.z - this.northCorner.z > zWall.southCorner.z - zWall.northCorner.z;
    }

    @Override
    public boolean sameLengthOnAxis(Wall<?> wall) {
        return this.sameHeight(wall.toZWall());
    }

    @Override
    public ZWall shiftedNegative(int i) {
        return this.shiftedWest(i);
    }

    @Override
    public ZWall shiftedPositive(int i) {
        return this.shiftedEast(i);
    }

    @Override
    public ZWall extendNegative(int i) {
        return this.extendNorthEnd(i);
    }

    @Override
    public ZWall extendPositive(int i) {
        return this.extendSouthEnd(i);
    }

    @Override
    public XWall toXWall() {
        throw new IllegalStateException("Cannot convert ZWall to XWall");
    }

    @Override
    public ZWall toZWall() {
        return this;
    }

    @Override
    public boolean isLargerOnAxis(Wall<?> wall) {
        return this.isLargerThan(wall.toZWall());
    }

    @Override
    public boolean isSameContentOnAxis(Wall<?> w, WallDetector wd) {
        return this.isSameContentAs(w.toZWall(), wd);
    }

    @Override
    public Wall<?> shifted(Direction s, int i) {
        return switch (s) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH, Direction.SOUTH -> throw new IllegalStateException("ZWalls cannot be shifted north or south");
            case Direction.WEST -> this.shiftedWest(i);
            case Direction.EAST -> this.shiftedEast(i);
        };
    }

    @Override
    public Position negativeCorner() {
        return this.northCorner;
    }

    @Override
    public Position positiveCorner() {
        return this.southCorner;
    }

    @Override
    public ZWall shortenNegative(int i) {
        return this.shortenNorthEnd(i);
    }

    @Override
    public ZWall shortenPositive(int i) {
        return this.shortenSouthEnd(i);
    }

    @Override
    public int getLengthOnAxis() {
        return this.getLength();
    }

    @Override
    public String toShortString() {
        return String.format("%s->%s", this.northCorner.getUIString(), this.southCorner.getUIString());
    }
}

