/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.testutil;

import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.LevelRoomDetector;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Debugger {
    @Nullable
    public static Consumer<String> on(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        try {
            LocalDate specificDate = LocalDate.parse(date, formatter);
            LocalDate today = LocalDate.now();
            if (today.isBefore(specificDate.plusDays(15L))) {
                return System.out::println;
            }
        }
        catch (DateTimeParseException e) {
            System.err.println("Invalid date format: " + date);
        }
        return str -> {};
    }

    @NotNull
    public static String getDebugArt(ImmutableSet<Position> positions) {
        String[][] art = new String[200][200];
        for (Position position : positions) {
            LevelRoomDetector.captureAsArtPixel(position, new Position(0, 0), art, true, "W", " ", 5);
        }
        return (String)LevelRoomDetector.doGetDebugArt((Map<Position, String[][]>)ImmutableMap.of((Object)new Position(0, 0), (Object)art), true).get((Object)new Position(0, 0));
    }
}

